/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack.texture;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonStreamParser;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resourcepack.ParseResourceException;
import de.bluecolored.bluemap.core.resourcepack.fileaccess.FileAccess;
import de.bluecolored.bluemap.core.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.FileUtils;
import de.bluecolored.bluemap.core.util.math.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.imageio.ImageIO;

public class TextureGallery {
    private static final String EMPTY_BASE64 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAQAAAC1+jfqAAAAEUlEQVR42mNkIAAYRxWMJAUAE5gAEdz4t9QAAAAASUVORK5CYII=";
    private final Map<String, Texture> textureMap = new HashMap<String, Texture>();
    private final List<Texture> textureList = new ArrayList<Texture>();

    public Texture get(int id) {
        return this.textureList.get(id);
    }

    public Texture get(String path) {
        Texture texture = this.textureMap.get(path);
        if (texture == null) {
            throw new NoSuchElementException("There is no texture with the path " + path + " in this gallery!");
        }
        return texture;
    }

    public int size() {
        return this.textureList.size();
    }

    public void saveTextureFile(File file) throws IOException {
        JsonArray textures = new JsonArray();
        for (int i = 0; i < this.textureList.size(); ++i) {
            Texture texture = this.textureList.get(i);
            JsonObject textureNode = new JsonObject();
            textureNode.addProperty("id", texture.getPath());
            textureNode.addProperty("texture", texture.getTexture());
            textureNode.addProperty("transparent", Boolean.valueOf(texture.isHalfTransparent()));
            Color color = texture.getColorStraight();
            JsonArray colorNode = new JsonArray();
            colorNode.add((Number)Float.valueOf(color.r));
            colorNode.add((Number)Float.valueOf(color.g));
            colorNode.add((Number)Float.valueOf(color.b));
            colorNode.add((Number)Float.valueOf(color.a));
            textureNode.add("color", (JsonElement)colorNode);
            textures.add((JsonElement)textureNode);
        }
        JsonObject root = new JsonObject();
        root.add("textures", (JsonElement)textures);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)root);
        if (file.exists()) {
            FileUtils.delete(file);
        }
        FileUtils.createFile(file);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.append(json);
            fileWriter.flush();
        }
    }

    public synchronized void loadTextureFile(File file) throws IOException, ParseResourceException {
        this.textureList.clear();
        this.textureMap.clear();
        try (FileReader fileReader = new FileReader(file);){
            JsonStreamParser jsonFile = new JsonStreamParser((Reader)fileReader);
            JsonArray textures = jsonFile.next().getAsJsonObject().getAsJsonArray("textures");
            int size = textures.size();
            for (int i = 0; i < size; ++i) {
                while (i >= this.textureList.size()) {
                    this.textureList.add(new Texture(this.textureList.size(), "empty", new Color(), false, EMPTY_BASE64));
                }
                try {
                    JsonObject texture = textures.get(i).getAsJsonObject();
                    String path = texture.get("id").getAsString();
                    boolean transparent = texture.get("transparent").getAsBoolean();
                    Color color = this.readColor(texture.get("color").getAsJsonArray());
                    this.textureList.set(i, new Texture(i, path, color, transparent, texture.get("texture").getAsString()));
                    continue;
                }
                catch (ParseResourceException | RuntimeException ex) {
                    Logger.global.logWarning("Failed to load texture with id " + i + " from texture file " + file + "!");
                }
            }
        }
        catch (RuntimeException ex) {
            throw new ParseResourceException("Invalid texture file format!", ex);
        }
        finally {
            this.regenerateMap();
        }
    }

    public synchronized Texture loadTexture(FileAccess fileAccess, String path) throws FileNotFoundException, IOException {
        try (InputStream input = fileAccess.readFile(path);){
            BufferedImage image = ImageIO.read(input);
            if (image == null) {
                throw new IOException("Failed to read image: " + path);
            }
            if (image.getHeight() > image.getWidth()) {
                image = image.getSubimage(0, 0, image.getWidth(), image.getWidth());
            }
            boolean halfTransparent = this.checkHalfTransparent(image);
            Color color = this.calculateColor(image);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", os);
            String base64 = "data:image/png;base64," + Base64.getEncoder().encodeToString(os.toByteArray());
            Texture texture = this.textureMap.get(path);
            if (texture != null) {
                texture = new Texture(texture.getId(), path, color, halfTransparent, base64);
                this.textureMap.put(path, texture);
                this.textureList.set(texture.getId(), texture);
            } else {
                texture = new Texture(this.textureList.size(), path, color, halfTransparent, base64);
                this.textureMap.put(path, texture);
                this.textureList.add(texture);
            }
            Texture texture2 = texture;
            return texture2;
        }
    }

    public synchronized void reloadAllTextures(FileAccess fileAccess) {
        for (Texture texture : this.textureList.toArray(new Texture[this.textureList.size()])) {
            try {
                this.loadTexture(fileAccess, texture.getPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private synchronized void regenerateMap() {
        this.textureMap.clear();
        for (int i = 0; i < this.textureList.size(); ++i) {
            Texture texture = this.textureList.get(i);
            this.textureMap.put(texture.getPath(), texture);
        }
    }

    private Color readColor(JsonArray jsonArray) throws ParseResourceException {
        if (jsonArray.size() < 4) {
            throw new ParseResourceException("Failed to load Vector4: Not enough values in list-node!");
        }
        float r = jsonArray.get(0).getAsFloat();
        float g2 = jsonArray.get(1).getAsFloat();
        float b = jsonArray.get(2).getAsFloat();
        float a = jsonArray.get(3).getAsFloat();
        return new Color().set(r, g2, b, a, false);
    }

    private boolean checkHalfTransparent(BufferedImage image) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int pixel = image.getRGB(x, y);
                int alpha = pixel >> 24 & 0xFF;
                if (alpha <= 0 || alpha >= 255) continue;
                return true;
            }
        }
        return false;
    }

    private Color calculateColor(BufferedImage image) {
        float alpha = 0.0f;
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        int count = 0;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int pixel = image.getRGB(x, y);
                float pixelAlpha = (float)(pixel >> 24 & 0xFF) / 255.0f;
                float pixelRed = (float)(pixel >> 16 & 0xFF) / 255.0f;
                float pixelGreen = (float)(pixel >> 8 & 0xFF) / 255.0f;
                float pixelBlue = (float)(pixel & 0xFF) / 255.0f;
                ++count;
                alpha += pixelAlpha;
                red += pixelRed * pixelAlpha;
                green += pixelGreen * pixelAlpha;
                blue += pixelBlue * pixelAlpha;
            }
        }
        if (count == 0 || alpha == 0.0f) {
            return new Color();
        }
        red /= alpha;
        green /= alpha;
        blue /= alpha;
        return new Color().set(red, green, blue, alpha /= (float)count, false);
    }
}

