/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack.fileaccess;

import de.bluecolored.bluemap.core.resourcepack.fileaccess.FileAccess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipFileAccess
implements FileAccess {
    private ZipFile file;

    public ZipFileAccess(File file) throws ZipException, IOException {
        this.file = new ZipFile(file);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public InputStream readFile(String path) throws FileNotFoundException, IOException {
        ZipEntry entry = this.file.getEntry(path);
        if (entry == null) {
            throw new FileNotFoundException("File " + path + " does not exist in this zip-file!");
        }
        return this.file.getInputStream(entry);
    }

    @Override
    public Collection<String> listFiles(String path, boolean recursive) {
        path = this.normalizeFolderPath(path);
        ArrayList<String> files = new ArrayList<String>();
        Enumeration<? extends ZipEntry> entries = this.file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String file = entry.getName();
            int nameSplit = file.lastIndexOf(47);
            String filePath = "";
            if (nameSplit != -1) {
                filePath = file.substring(0, nameSplit);
            }
            filePath = this.normalizeFolderPath(filePath);
            if (recursive ? !filePath.startsWith(path) && !path.equals(filePath) : !path.equals(filePath)) continue;
            files.add(file);
        }
        return files;
    }

    @Override
    public Collection<String> listFolders(String path) {
        path = this.normalizeFolderPath(path);
        HashSet<String> folders = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = this.file.entries();
        while (entries.hasMoreElements()) {
            int nameSplit;
            ZipEntry entry = entries.nextElement();
            String file = entry.getName();
            if (!entry.isDirectory()) {
                nameSplit = file.lastIndexOf(47);
                if (nameSplit == -1) continue;
                file = file.substring(0, nameSplit);
            }
            file = this.normalizeFolderPath(file);
            file = file.substring(0, file.length() - 1);
            nameSplit = file.lastIndexOf(47);
            String filePath = "/";
            if (nameSplit != -1) {
                filePath = file.substring(0, nameSplit);
            }
            if (!(filePath = this.normalizeFolderPath(filePath)).startsWith(path)) continue;
            int subFolderMark = file.indexOf(47, path.length());
            if (subFolderMark != -1) {
                file = file.substring(0, subFolderMark);
            }
            file = this.normalizeFolderPath(file);
            file = file.substring(0, file.length() - 1);
            folders.add(file);
        }
        return folders;
    }

    private String normalizeFolderPath(String path) {
        if (path.isEmpty()) {
            return path;
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

