/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack.fileaccess;

import de.bluecolored.bluemap.core.resourcepack.fileaccess.FileAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FolderFileAccess
implements FileAccess {
    private File folder;
    private Collection<WeakReference<InputStream>> openedStreams;

    public FolderFileAccess(File folder) {
        this.folder = folder;
        this.openedStreams = new ArrayList<WeakReference<InputStream>>();
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    @Override
    public synchronized InputStream readFile(String path) throws FileNotFoundException {
        FileInputStream stream = new FileInputStream(this.resolve(path).toFile());
        this.tidy();
        this.openedStreams.add(new WeakReference<FileInputStream>(stream));
        return stream;
    }

    @Override
    public Collection<String> listFiles(String path, boolean recursive) {
        File subFolder = this.resolve(path).toFile();
        ArrayList<String> paths = new ArrayList<String>();
        this.listFiles(subFolder, paths, recursive);
        return paths;
    }

    private void listFiles(File folder, Collection<String> paths, boolean recursive) {
        if (!folder.isDirectory()) {
            return;
        }
        for (File file : folder.listFiles()) {
            if (recursive && file.isDirectory()) {
                this.listFiles(file, paths, true);
            }
            if (!file.isFile()) continue;
            paths.add(this.toPath(file));
        }
    }

    @Override
    public Collection<String> listFolders(String path) {
        File subFolder = this.resolve(path).toFile();
        ArrayList<String> paths = new ArrayList<String>();
        if (subFolder.isDirectory()) {
            for (File file : subFolder.listFiles()) {
                if (!file.isDirectory()) continue;
                paths.add(this.toPath(file));
            }
        }
        return paths;
    }

    @Override
    public synchronized void close() throws IOException {
        IOException exception = null;
        for (WeakReference<InputStream> streamRef : this.openedStreams) {
            try {
                InputStream stream = (InputStream)streamRef.get();
                if (stream != null) {
                    stream.close();
                }
                streamRef.clear();
            }
            catch (IOException ex) {
                if (exception == null) {
                    exception = ex;
                    continue;
                }
                exception.addSuppressed(ex);
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.openedStreams.clear();
    }

    private synchronized void tidy() {
        Iterator<WeakReference<InputStream>> iterator = this.openedStreams.iterator();
        while (iterator.hasNext()) {
            WeakReference<InputStream> ref = iterator.next();
            if (ref.get() != null) continue;
            iterator.remove();
        }
    }

    private Path resolve(String path) {
        if (path.isEmpty() || "/".equals(path)) {
            return this.folder.toPath();
        }
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        Path resolve = this.folder.toPath();
        for (String s2 : path.split("/")) {
            resolve = resolve.resolve(s2);
        }
        return resolve;
    }

    private String toPath(File file) {
        return this.toPath(file.toPath());
    }

    private String toPath(Path path) {
        return this.folder.toPath().relativize(path).normalize().toString().replace(File.separatorChar, '/');
    }
}

