/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack.fileaccess;

import de.bluecolored.bluemap.core.resourcepack.fileaccess.FolderFileAccess;
import de.bluecolored.bluemap.core.resourcepack.fileaccess.ZipFileAccess;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

public interface FileAccess
extends Closeable,
AutoCloseable {
    public String getName();

    public InputStream readFile(String var1) throws FileNotFoundException, IOException;

    public Collection<String> listFiles(String var1, boolean var2);

    public Collection<String> listFolders(String var1);

    public static FileAccess of(File file) throws IOException {
        if (file.isDirectory()) {
            return new FolderFileAccess(file);
        }
        if (file.isFile()) {
            return new ZipFileAccess(file);
        }
        throw new IOException("Unsupported file!");
    }

    public static String getFileName(String path) {
        String filename = path;
        int nameSplit = path.lastIndexOf(47);
        if (nameSplit > -1) {
            filename = path.substring(nameSplit + 1);
        }
        return filename;
    }

    public static String normalize(String path) {
        if (path.isEmpty()) {
            return path;
        }
        if (path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty()) {
            return path;
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }
}

