/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack.fileaccess;

import de.bluecolored.bluemap.core.resourcepack.fileaccess.FileAccess;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CombinedFileAccess
implements FileAccess {
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    public List<FileAccess> sources = new ArrayList<FileAccess>();
    private Map<String, FileAccess> sourceMap = new HashMap<String, FileAccess>();
    private Set<String> allFiles = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileAccess(FileAccess source) {
        this.rwLock.writeLock().lock();
        try {
            this.sources.add(source);
            Collection<String> sourceFiles = source.listFiles("", true);
            for (String path : sourceFiles) {
                this.sourceMap.put(FileAccess.normalize(path), source);
            }
            this.allFiles.addAll(sourceFiles);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public String getName() {
        return "CombinedFileAccess(" + this.sources.size() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream readFile(String path) throws FileNotFoundException, IOException {
        this.rwLock.readLock().lock();
        try {
            FileAccess source = this.sourceMap.get(FileAccess.normalize(path));
            if (source != null) {
                InputStream inputStream = source.readFile(path);
                return inputStream;
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        throw new FileNotFoundException("File " + path + " does not exist in any of the sources!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> listFiles(String path, boolean recursive) {
        path = this.normalizeFolderPath(path);
        ArrayList<String> files = new ArrayList<String>();
        this.rwLock.readLock().lock();
        try {
            for (String file : this.allFiles) {
                int nameSplit = file.lastIndexOf(47);
                String filePath = "";
                if (nameSplit != -1) {
                    filePath = file.substring(0, nameSplit);
                }
                filePath = this.normalizeFolderPath(filePath);
                if (recursive ? !filePath.startsWith(path) && !path.equals(filePath) : !path.equals(filePath)) continue;
                files.add(file);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return files;
    }

    private String normalizeFolderPath(String path) {
        if (path.isEmpty()) {
            return path;
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> listFolders(String path) {
        HashSet<String> folders = new HashSet<String>();
        this.rwLock.readLock().lock();
        try {
            for (int i = 0; i < this.sources.size(); ++i) {
                folders.addAll(this.sources.get(i).listFolders(path));
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return folders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        IOException exception = null;
        this.rwLock.writeLock().lock();
        try {
            for (FileAccess source : this.sources) {
                try {
                    source.close();
                }
                catch (IOException ex) {
                    if (exception == null) {
                        exception = ex;
                        continue;
                    }
                    exception.addSuppressed(ex);
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (exception != null) {
            throw exception;
        }
    }
}

