/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack.fileaccess;

import de.bluecolored.bluemap.core.resourcepack.fileaccess.FileAccess;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

public class CaseInsensitiveFileAccess
implements FileAccess {
    public FileAccess parent;

    public CaseInsensitiveFileAccess(FileAccess parent) {
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.parent.getName() + "(CI)";
    }

    @Override
    public InputStream readFile(String path) throws FileNotFoundException, IOException {
        try {
            return this.parent.readFile(path);
        }
        catch (FileNotFoundException ex) {
            try {
                return this.parent.readFile(path.toLowerCase());
            }
            catch (FileNotFoundException ex2) {
                path = this.correctPathCase(path);
                return this.parent.readFile(path);
            }
        }
    }

    private String correctPathCase(String path) throws FileNotFoundException, IOException {
        path = FileAccess.normalize(path);
        String[] pathParts = path.split("/");
        String correctPath = "";
        for (int i = 0; i < pathParts.length; ++i) {
            String part = correctPath + pathParts[i];
            boolean found = false;
            for (String folder : this.listFolders(correctPath)) {
                if (!folder.equalsIgnoreCase(part)) continue;
                part = folder;
                found = true;
                break;
            }
            if (!found && i == pathParts.length - 1) {
                for (String folder : this.listFiles(correctPath, false)) {
                    if (!folder.equalsIgnoreCase(part)) continue;
                    part = folder;
                    found = true;
                    break;
                }
            }
            if (!found) {
                throw new FileNotFoundException();
            }
            correctPath = part + "/";
        }
        correctPath = FileAccess.normalize(correctPath);
        return correctPath;
    }

    @Override
    public Collection<String> listFiles(String path, boolean recursive) {
        return this.parent.listFiles(path, recursive);
    }

    @Override
    public Collection<String> listFolders(String path) {
        return this.parent.listFolders(path);
    }

    @Override
    public void close() throws IOException {
        this.parent.close();
    }
}

