/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack.fileaccess;

import de.bluecolored.bluemap.core.resourcepack.fileaccess.FileAccess;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class BluemapAssetOverrideFileAccess
implements FileAccess {
    public FileAccess parent;

    public BluemapAssetOverrideFileAccess(FileAccess parent) {
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.parent.getName() + "*";
    }

    @Override
    public InputStream readFile(String path) throws FileNotFoundException, IOException {
        String[] pathParts = StringUtils.split((String)path, (String)"/");
        if (pathParts.length < 3 || !pathParts[0].equals("assets")) {
            return this.parent.readFile(path);
        }
        CharSequence[] newParts = new String[pathParts.length + 1];
        System.arraycopy(pathParts, 0, newParts, 0, 2);
        System.arraycopy(pathParts, 2, newParts, 3, pathParts.length - 2);
        newParts[2] = "bluemap";
        String newPath = String.join((CharSequence)"/", newParts);
        try {
            return this.parent.readFile(newPath);
        }
        catch (FileNotFoundException ex) {
            return this.parent.readFile(path);
        }
    }

    @Override
    public Collection<String> listFiles(String path, boolean recursive) {
        return this.parent.listFiles(path, recursive);
    }

    @Override
    public Collection<String> listFolders(String path) {
        return this.parent.listFolders(path);
    }

    @Override
    public void close() throws IOException {
        this.parent.close();
    }
}

