/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack.blockstate;

import de.bluecolored.bluemap.core.resourcepack.ParseResourceException;
import de.bluecolored.bluemap.core.resourcepack.blockmodel.TransformedBlockModelResource;
import de.bluecolored.bluemap.core.resourcepack.blockstate.PropertyCondition;
import de.bluecolored.bluemap.core.resourcepack.blockstate.Weighted;
import java.util.ArrayList;
import java.util.Collection;

public class Variant {
    PropertyCondition condition = PropertyCondition.all();
    Collection<Weighted<TransformedBlockModelResource>> models = new ArrayList<Weighted<TransformedBlockModelResource>>(0);
    private double totalWeight;

    Variant() {
    }

    public TransformedBlockModelResource getModel(int x, int y, int z) {
        if (this.models.isEmpty()) {
            throw new IllegalStateException("A variant must have at least one model!");
        }
        double selection = (double)Variant.hashToFloat(x, y, z) * this.totalWeight;
        for (Weighted<TransformedBlockModelResource> w : this.models) {
            if (!((selection -= w.getWeight()) <= 0.0)) continue;
            return w.getValue();
        }
        throw new RuntimeException("This line should never be reached!");
    }

    public void checkValid() throws ParseResourceException {
        if (this.models.isEmpty()) {
            throw new ParseResourceException("A variant must have at least one model!");
        }
    }

    public void updateTotalWeight() {
        this.totalWeight = 0.0;
        for (Weighted<TransformedBlockModelResource> w : this.models) {
            this.totalWeight += w.getWeight();
        }
    }

    private static float hashToFloat(int x, int y, int z) {
        long hash = x * 73438747 ^ y * 9357269 ^ z * 4335792;
        return (float)(hash * (hash + 456149L) & 0xFFFFFFL) / 1.6777216E7f;
    }
}

