/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack.blockstate;

import de.bluecolored.bluemap.core.util.Preconditions;
import de.bluecolored.bluemap.core.world.BlockState;
import java.util.Map;

@FunctionalInterface
public interface PropertyCondition {
    public static final PropertyCondition MATCH_ALL = new All();
    public static final PropertyCondition MATCH_NONE = new None();

    public boolean matches(BlockState var1);

    public static PropertyCondition all() {
        return MATCH_ALL;
    }

    public static PropertyCondition none() {
        return MATCH_NONE;
    }

    public static PropertyCondition and(PropertyCondition ... conditions) {
        Preconditions.checkArgument(conditions.length > 0, "Must be at least one condition!");
        return new And(conditions);
    }

    public static PropertyCondition or(PropertyCondition ... conditions) {
        Preconditions.checkArgument(conditions.length > 0, "Must be at least one condition!");
        return new Or(conditions);
    }

    public static PropertyCondition property(String key, String value) {
        return new Property(key, value);
    }

    public static PropertyCondition property(String key, String ... possibleValues) {
        Preconditions.checkArgument(possibleValues.length > 0, "Must be at least one value!");
        if (possibleValues.length == 1) {
            return PropertyCondition.property(key, possibleValues[0]);
        }
        PropertyCondition[] conditions = new PropertyCondition[possibleValues.length];
        for (int i = 0; i < possibleValues.length; ++i) {
            conditions[i] = PropertyCondition.property(key, possibleValues[i]);
        }
        return PropertyCondition.or(conditions);
    }

    public static PropertyCondition blockState(BlockState state) {
        Map<String, String> props = state.getProperties();
        if (props.isEmpty()) {
            return PropertyCondition.all();
        }
        PropertyCondition[] conditions = new Property[props.size()];
        int i = 0;
        for (Map.Entry<String, String> prop : props.entrySet()) {
            conditions[i++] = PropertyCondition.property(prop.getKey(), prop.getValue());
        }
        return PropertyCondition.and(conditions);
    }

    public static class And
    implements PropertyCondition {
        private final PropertyCondition[] conditions;

        private And(PropertyCondition ... conditions) {
            Preconditions.checkArgument(conditions.length > 0, "Must be at least one condition!");
            this.conditions = conditions;
        }

        @Override
        public boolean matches(BlockState state) {
            for (PropertyCondition condition : this.conditions) {
                if (condition.matches(state)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Or
    implements PropertyCondition {
        private final PropertyCondition[] conditions;

        private Or(PropertyCondition ... conditions) {
            Preconditions.checkArgument(conditions.length > 0, "Must be at least one condition!");
            this.conditions = conditions;
        }

        @Override
        public boolean matches(BlockState state) {
            for (PropertyCondition condition : this.conditions) {
                if (!condition.matches(state)) continue;
                return true;
            }
            return false;
        }
    }

    public static class Property
    implements PropertyCondition {
        private final String key;
        private final String value;

        private Property(String key, String value) {
            this.key = key.toLowerCase();
            this.value = value.toLowerCase();
        }

        @Override
        public boolean matches(BlockState state) {
            String value = state.getProperties().get(this.key);
            if (value == null) {
                return false;
            }
            return value.equals(this.value);
        }
    }

    public static class All
    implements PropertyCondition {
        @Override
        public boolean matches(BlockState state) {
            return true;
        }
    }

    public static class None
    implements PropertyCondition {
        @Override
        public boolean matches(BlockState state) {
            return false;
        }
    }
}

