/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack.blockstate;

import com.flowpowered.math.vector.Vector2f;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resourcepack.ParseResourceException;
import de.bluecolored.bluemap.core.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resourcepack.blockmodel.BlockModelResource;
import de.bluecolored.bluemap.core.resourcepack.blockmodel.TransformedBlockModelResource;
import de.bluecolored.bluemap.core.resourcepack.blockstate.PropertyCondition;
import de.bluecolored.bluemap.core.resourcepack.blockstate.Variant;
import de.bluecolored.bluemap.core.resourcepack.blockstate.Weighted;
import de.bluecolored.bluemap.core.resourcepack.fileaccess.FileAccess;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BlockStateResource {
    private final List<Variant> variants = new ArrayList<Variant>(0);
    private final Collection<Variant> multipart = new ArrayList<Variant>(0);

    private BlockStateResource() {
    }

    public Collection<TransformedBlockModelResource> getModels(BlockState blockState, Collection<TransformedBlockModelResource> targetCollection) {
        return this.getModels(blockState, 0, 0, 0, targetCollection);
    }

    public Collection<TransformedBlockModelResource> getModels(BlockState blockState, int x, int y, int z, Collection<TransformedBlockModelResource> targetCollection) {
        targetCollection.clear();
        Variant allMatch = null;
        for (Variant variant : this.variants) {
            if (!variant.condition.matches(blockState)) continue;
            if (variant.condition instanceof PropertyCondition.All) {
                if (allMatch != null) continue;
                allMatch = variant;
                continue;
            }
            targetCollection.add(variant.getModel(x, y, z));
            return targetCollection;
        }
        if (allMatch != null) {
            targetCollection.add(allMatch.getModel(x, y, z));
            return targetCollection;
        }
        for (Variant variant : this.multipart) {
            if (!variant.condition.matches(blockState)) continue;
            targetCollection.add(variant.getModel(x, y, z));
        }
        if (targetCollection.isEmpty() && !this.variants.isEmpty()) {
            targetCollection.add(this.variants.get(0).getModel(x, y, z));
        }
        return targetCollection;
    }

    public static Builder builder(FileAccess sourcesAccess, ResourcePack resourcePack) {
        return new Builder(sourcesAccess, resourcePack);
    }

    public static class Builder {
        private static final String JSON_COMMENT = "__comment";
        private final FileAccess sourcesAccess;
        private final ResourcePack resourcePack;

        private Builder(FileAccess sourcesAccess, ResourcePack resourcePack) {
            this.sourcesAccess = sourcesAccess;
            this.resourcePack = resourcePack;
        }

        public BlockStateResource build(String blockstateFile) throws IOException {
            InputStream fileIn = this.sourcesAccess.readFile(blockstateFile);
            Object config = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().source(() -> new BufferedReader(new InputStreamReader(fileIn, StandardCharsets.UTF_8)))).build().load();
            if (!config.node("forge_marker").virtual()) {
                return this.buildForge((ConfigurationNode)config, blockstateFile);
            }
            BlockStateResource blockState = new BlockStateResource();
            for (Map.Entry<Object, ? extends ConfigurationNode> entry : config.node("variants").childrenMap().entrySet()) {
                if (entry.getKey().equals(JSON_COMMENT)) continue;
                try {
                    String conditionString = entry.getKey().toString();
                    ConfigurationNode transformedModelNode = entry.getValue();
                    if (conditionString.equals("all") || conditionString.equals("map")) continue;
                    Variant variant = new Variant();
                    variant.condition = this.parseConditionString(conditionString);
                    variant.models = this.loadModels(transformedModelNode, blockstateFile, null);
                    variant.updateTotalWeight();
                    variant.checkValid();
                    blockState.variants.add(variant);
                }
                catch (ParseResourceException | RuntimeException e) {
                    Builder.logParseError("Failed to parse a variant of " + blockstateFile, e);
                }
            }
            for (ConfigurationNode configurationNode : config.node("multipart").childrenList()) {
                try {
                    Variant variant = new Variant();
                    ConfigurationNode whenNode = configurationNode.node("when");
                    if (!whenNode.virtual()) {
                        variant.condition = this.parseCondition(whenNode);
                    }
                    variant.models = this.loadModels(configurationNode.node("apply"), blockstateFile, null);
                    variant.updateTotalWeight();
                    variant.checkValid();
                    blockState.multipart.add(variant);
                }
                catch (ParseResourceException | RuntimeException e) {
                    Builder.logParseError("Failed to parse a multipart-part of " + blockstateFile, e);
                }
            }
            return blockState;
        }

        private Collection<Weighted<TransformedBlockModelResource>> loadModels(ConfigurationNode node, String blockstateFile, Map<String, String> overrideTextures) {
            ArrayList<Weighted<TransformedBlockModelResource>> models;
            block6: {
                block5: {
                    models = new ArrayList<Weighted<TransformedBlockModelResource>>();
                    if (!node.isList()) break block5;
                    for (ConfigurationNode configurationNode : node.childrenList()) {
                        try {
                            models.add(this.loadModel(configurationNode, overrideTextures));
                        }
                        catch (ParseResourceException ex) {
                            Builder.logParseError("Failed to load a model trying to parse " + blockstateFile, ex);
                        }
                    }
                    break block6;
                }
                if (!node.isMap()) break block6;
                try {
                    models.add(this.loadModel(node, overrideTextures));
                }
                catch (ParseResourceException ex) {
                    Builder.logParseError("Failed to load a model trying to parse " + blockstateFile, ex);
                }
            }
            return models;
        }

        private Weighted<TransformedBlockModelResource> loadModel(ConfigurationNode node, Map<String, String> overrideTextures) throws ParseResourceException {
            String namespacedModelPath = node.node("model").getString();
            if (namespacedModelPath == null) {
                throw new ParseResourceException("No model defined!");
            }
            String modelPath = ResourcePack.namespacedToAbsoluteResourcePath(namespacedModelPath, "models") + ".json";
            BlockModelResource model = this.resourcePack.getBlockModelResources().get(modelPath);
            if (model == null) {
                BlockModelResource.Builder builder = BlockModelResource.builder(this.sourcesAccess, this.resourcePack);
                try {
                    model = overrideTextures != null ? builder.build(modelPath, overrideTextures) : builder.build(modelPath);
                }
                catch (IOException e) {
                    throw new ParseResourceException("Failed to load model " + modelPath, e);
                }
                this.resourcePack.getBlockModelResources().put(modelPath, model);
            }
            Vector2f rotation = new Vector2f(node.node("x").getFloat(0.0f), node.node("y").getFloat(0.0f));
            boolean uvLock = node.node("uvlock").getBoolean(false);
            TransformedBlockModelResource transformedModel = new TransformedBlockModelResource(rotation, uvLock, model);
            return new Weighted<TransformedBlockModelResource>(transformedModel, node.node("weight").getDouble(1.0));
        }

        private PropertyCondition parseCondition(ConfigurationNode conditionNode) {
            ArrayList<PropertyCondition> andConditions = new ArrayList<PropertyCondition>();
            for (Map.Entry<Object, ? extends ConfigurationNode> entry : conditionNode.childrenMap().entrySet()) {
                String key = entry.getKey().toString();
                if (key.equals(JSON_COMMENT)) continue;
                if (key.equals("OR")) {
                    ArrayList<PropertyCondition> orConditions = new ArrayList<PropertyCondition>();
                    for (ConfigurationNode configurationNode : entry.getValue().childrenList()) {
                        orConditions.add(this.parseCondition(configurationNode));
                    }
                    andConditions.add(PropertyCondition.or(orConditions.toArray(new PropertyCondition[0])));
                    continue;
                }
                String[] values = StringUtils.split((String)entry.getValue().getString(""), (char)'|');
                andConditions.add(PropertyCondition.property(key, values));
            }
            return PropertyCondition.and(andConditions.toArray(new PropertyCondition[0]));
        }

        private PropertyCondition parseConditionString(String conditionString) throws IllegalArgumentException {
            ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
            if (!(conditionString.isEmpty() || conditionString.equals("default") || conditionString.equals("normal"))) {
                String[] conditionSplit;
                for (String element : conditionSplit = StringUtils.split((String)conditionString, (char)',')) {
                    String[] keyval = StringUtils.split((String)element, (String)"=", (int)2);
                    if (keyval.length < 2) {
                        throw new IllegalArgumentException("Condition-String '" + conditionString + "' is invalid!");
                    }
                    conditions.add(PropertyCondition.property(keyval[0], keyval[1]));
                }
            }
            PropertyCondition condition = conditions.isEmpty() ? PropertyCondition.all() : (conditions.size() == 1 ? (PropertyCondition)conditions.get(0) : PropertyCondition.and(conditions.toArray(new PropertyCondition[0])));
            return condition;
        }

        private BlockStateResource buildForge(ConfigurationNode config, String blockstateFile) {
            Object variant;
            ConfigurationNode modelDefaults = config.node("defaults");
            ArrayList<ForgeVariant> variants = new ArrayList<ForgeVariant>();
            for (Map.Entry<Object, ? extends ConfigurationNode> entry : config.node("variants").childrenMap().entrySet()) {
                if (entry.getKey().equals(JSON_COMMENT) || this.isForgeStraightVariant((ConfigurationNode)entry.getValue())) continue;
                ArrayList<ForgeVariant> propertyVariants = new ArrayList<ForgeVariant>();
                String key = entry.getKey().toString();
                for (Map.Entry<Object, ? extends ConfigurationNode> entry2 : ((ConfigurationNode)entry.getValue()).childrenMap().entrySet()) {
                    if (entry2.getKey().equals(JSON_COMMENT)) continue;
                    ForgeVariant variant2 = new ForgeVariant();
                    variant2.properties.put(key, entry2.getKey().toString());
                    variant2.node = entry2.getValue();
                    propertyVariants.add(variant2);
                }
                if (variants.isEmpty()) {
                    variants = propertyVariants;
                    continue;
                }
                ArrayList<ForgeVariant> arrayList = variants;
                variants = new ArrayList(arrayList.size() * propertyVariants.size());
                for (Object oldVariant : arrayList) {
                    for (ForgeVariant forgeVariant : propertyVariants) {
                        variants.add(((ForgeVariant)oldVariant).createMerge(forgeVariant));
                    }
                }
            }
            BlockStateResource blockState = new BlockStateResource();
            for (ForgeVariant forgeVariant : variants) {
                variant = new Variant();
                ConfigurationNode configurationNode = forgeVariant.node.mergeFrom(modelDefaults);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (Map.Entry<Object, ? extends ConfigurationNode> entry : configurationNode.node("textures").childrenMap().entrySet()) {
                    if (entry.getKey().equals(JSON_COMMENT)) continue;
                    hashMap.putIfAbsent(entry.getKey().toString(), entry.getValue().getString());
                }
                ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>(forgeVariant.properties.size());
                for (Map.Entry<String, String> entry : forgeVariant.properties.entrySet()) {
                    conditions.add(PropertyCondition.property(entry.getKey(), entry.getValue()));
                }
                ((Variant)variant).condition = PropertyCondition.and(conditions.toArray(new PropertyCondition[0]));
                ((Variant)variant).models.addAll(this.loadModels(configurationNode, blockstateFile, hashMap));
                for (Map.Entry<Object, ? extends ConfigurationNode> entry : configurationNode.node("submodel").childrenMap().entrySet()) {
                    if (entry.getKey().equals(JSON_COMMENT)) continue;
                    ((Variant)variant).models.addAll(this.loadModels(entry.getValue(), blockstateFile, hashMap));
                }
                ((Variant)variant).updateTotalWeight();
                try {
                    ((Variant)variant).checkValid();
                    blockState.variants.add(variant);
                }
                catch (ParseResourceException parseResourceException) {
                    Builder.logParseError("Failed to parse a variant (forge/property) of " + blockstateFile, parseResourceException);
                }
            }
            ConfigurationNode normalNode = config.node("variants", "normal");
            if (normalNode.virtual() || this.isForgeStraightVariant(normalNode)) {
                normalNode.mergeFrom(modelDefaults);
                HashMap<String, String> textures = new HashMap<String, String>();
                for (Map.Entry entry : normalNode.node("textures").childrenMap().entrySet()) {
                    if (entry.getKey().equals(JSON_COMMENT)) continue;
                    textures.putIfAbsent(entry.getKey().toString(), ((ConfigurationNode)entry.getValue()).getString());
                }
                variant = new Variant();
                ((Variant)variant).condition = PropertyCondition.all();
                ((Variant)variant).models.addAll(this.loadModels(normalNode, blockstateFile, textures));
                for (Map.Entry<Object, ? extends ConfigurationNode> entry : normalNode.node("submodel").childrenMap().entrySet()) {
                    if (entry.getKey().equals(JSON_COMMENT)) continue;
                    ((Variant)variant).models.addAll(this.loadModels(entry.getValue(), blockstateFile, textures));
                }
                ((Variant)variant).updateTotalWeight();
                try {
                    ((Variant)variant).checkValid();
                    blockState.variants.add(variant);
                }
                catch (ParseResourceException parseResourceException) {
                    Builder.logParseError("Failed to parse a variant (forge/straight) of " + blockstateFile, parseResourceException);
                }
            }
            return blockState;
        }

        private boolean isForgeStraightVariant(ConfigurationNode node) {
            if (node.isList()) {
                return true;
            }
            for (Map.Entry<Object, ? extends ConfigurationNode> entry : node.childrenMap().entrySet()) {
                if (entry.getKey().equals(JSON_COMMENT) || entry.getValue().isMap()) continue;
                return true;
            }
            return false;
        }

        private static void logParseError(String message, Throwable throwable) {
            Logger.global.logDebug(message);
            while (throwable != null) {
                String errorMessage = throwable.getMessage();
                if (errorMessage == null) {
                    errorMessage = throwable.toString();
                }
                Logger.global.logDebug(" > " + errorMessage);
                throwable = throwable.getCause();
            }
        }

        private static class ForgeVariant {
            public Map<String, String> properties = new HashMap<String, String>();
            public ConfigurationNode node = GsonConfigurationLoader.builder().build().createNode();

            private ForgeVariant() {
            }

            public ForgeVariant createMerge(ForgeVariant other) {
                ForgeVariant merge = new ForgeVariant();
                merge.properties.putAll(this.properties);
                merge.properties.putAll(other.properties);
                merge.node.mergeFrom(this.node);
                merge.node.mergeFrom(other.node);
                return merge;
            }
        }
    }
}

