/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack.blockmodel;

import com.flowpowered.math.TrigMath;
import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector3i;
import com.flowpowered.math.vector.Vector4f;
import de.bluecolored.bluemap.core.resourcepack.ParseResourceException;
import de.bluecolored.bluemap.core.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resourcepack.blockmodel.ModelType;
import de.bluecolored.bluemap.core.resourcepack.fileaccess.FileAccess;
import de.bluecolored.bluemap.core.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Direction;
import de.bluecolored.bluemap.core.util.math.Axis;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class BlockModelResource {
    private static final double FIT_TO_BLOCK_SCALE_MULTIPLIER = 2.0 - Math.sqrt(2.0);
    private ModelType modelType = ModelType.NORMAL;
    private boolean culling = false;
    private boolean occluding = false;
    private final boolean ambientOcclusion = true;
    private final Collection<Element> elements = new ArrayList<Element>();
    private final Map<String, Texture> textures = new HashMap<String, Texture>();

    private BlockModelResource() {
    }

    public ModelType getType() {
        return this.modelType;
    }

    public boolean isAmbientOcclusion() {
        return true;
    }

    public boolean isCulling() {
        return this.culling;
    }

    public boolean isOccluding() {
        return this.occluding;
    }

    public Collection<Element> getElements() {
        return this.elements;
    }

    public Texture getTexture(String key) {
        return this.textures.get(key);
    }

    public static Builder builder(FileAccess sourcesAccess, ResourcePack resourcePack) {
        return new Builder(sourcesAccess, resourcePack);
    }

    public static class Builder {
        private static final String JSON_COMMENT = "__comment";
        private static final Vector3f FULL_CUBE_FROM = Vector3f.ZERO;
        private static final Vector3f FULL_CUBE_TO = new Vector3f(16.0f, 16.0f, 16.0f);
        private FileAccess sourcesAccess;
        private ResourcePack resourcePack;
        private HashMap<String, String> textures;

        private Builder(FileAccess sourcesAccess, ResourcePack resourcePack) {
            this.sourcesAccess = sourcesAccess;
            this.resourcePack = resourcePack;
            this.textures = new HashMap();
        }

        public synchronized BlockModelResource build(String modelPath) throws IOException, ParseResourceException {
            return this.build(modelPath, Collections.emptyMap());
        }

        public synchronized BlockModelResource build(String modelPath, Map<String, String> textures) throws IOException, ParseResourceException {
            this.textures.clear();
            this.textures.putAll(textures);
            return this.buildNoReset(modelPath, true, modelPath);
        }

        private BlockModelResource buildNoReset(String modelPath, boolean renderElements, String topModelPath) throws IOException, ParseResourceException {
            BlockModelResource blockModel = new BlockModelResource();
            InputStream fileIn = this.sourcesAccess.readFile(modelPath);
            Object config = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().source(() -> new BufferedReader(new InputStreamReader(fileIn, StandardCharsets.UTF_8)))).build().load();
            for (Map.Entry<Object, ? extends ConfigurationNode> entry : config.node("textures").childrenMap().entrySet()) {
                if (entry.getKey().equals(JSON_COMMENT)) continue;
                String string = entry.getKey().toString();
                String value = entry.getValue().getString();
                if (("#" + string).equals(value)) continue;
                this.textures.putIfAbsent(string, value);
            }
            String parentPath = config.node("parent").getString();
            if (parentPath != null) {
                if (parentPath.startsWith("builtin")) {
                    boolean bl;
                    Map.Entry<Object, ? extends ConfigurationNode> entry;
                    entry = parentPath;
                    int n = -1;
                    switch (((String)((Object)entry)).hashCode()) {
                        case 164135080: {
                            if (!((String)((Object)entry)).equals("builtin/liquid")) break;
                            bl = false;
                        }
                    }
                    switch (bl) {
                        case 0: {
                            blockModel.modelType = ModelType.LIQUID;
                        }
                    }
                } else {
                    try {
                        parentPath = ResourcePack.namespacedToAbsoluteResourcePath(parentPath, "models") + ".json";
                        blockModel = this.buildNoReset(parentPath, renderElements && config.node("elements").virtual(), topModelPath);
                    }
                    catch (IOException ex) {
                        throw new ParseResourceException("Failed to load parent model " + parentPath + " of model " + topModelPath, ex);
                    }
                }
            }
            if (renderElements) {
                for (ConfigurationNode configurationNode : config.node("elements").childrenList()) {
                    blockModel.elements.add(this.buildElement(blockModel, configurationNode, topModelPath));
                }
            }
            for (String string : this.textures.keySet()) {
                try {
                    blockModel.textures.put(string, this.getTexture("#" + string));
                }
                catch (FileNotFoundException | NoSuchElementException exception) {}
            }
            block13: for (Element element : blockModel.elements) {
                if (!element.isFullCube()) continue;
                blockModel.occluding = true;
                blockModel.culling = true;
                for (Direction dir : Direction.values()) {
                    Element.Face face = (Element.Face)element.faces.get((Object)dir);
                    if (face == null) {
                        blockModel.culling = false;
                        break block13;
                    }
                    Texture texture = face.getTexture();
                    if (texture == null) {
                        blockModel.culling = false;
                        break block13;
                    }
                    if (!(texture.getColorStraight().a < 1.0f)) continue;
                    blockModel.culling = false;
                    break block13;
                }
            }
            return blockModel;
        }

        private Element buildElement(BlockModelResource model, ConfigurationNode node, String topModelPath) throws ParseResourceException {
            boolean fullElement;
            BlockModelResource blockModelResource = model;
            Objects.requireNonNull(blockModelResource);
            Element element = blockModelResource.new Element();
            element.from = this.readVector3f(node.node("from"));
            element.to = this.readVector3f(node.node("to"));
            element.shade = node.node("shade").getBoolean(true);
            boolean bl = fullElement = element.from.equals(FULL_CUBE_FROM) && element.to.equals(FULL_CUBE_TO);
            if (!node.node("rotation").virtual()) {
                element.rotation.angle = node.node("rotation", "angle").getFloat(0.0f);
                element.rotation.axis = Axis.fromString(node.node("rotation", "axis").getString("x"));
                if (!node.node("rotation", "origin").virtual()) {
                    element.rotation.origin = this.readVector3f(node.node("rotation", "origin"));
                }
                element.rotation.rescale = node.node("rotation", "rescale").getBoolean(false);
                float angle = element.rotation.angle;
                Vector3i axis = element.rotation.axis.toVector();
                Vector3f origin = element.rotation.origin;
                boolean rescale = element.rotation.rescale;
                MatrixM4f rot = new MatrixM4f();
                if (angle != 0.0f) {
                    rot.translate(-origin.getX(), -origin.getY(), -origin.getZ());
                    rot.rotate(angle, axis.getX(), axis.getY(), axis.getZ());
                    if (rescale) {
                        float scale = (float)((double)Math.abs(TrigMath.sin((double)angle * (Math.PI / 180))) * FIT_TO_BLOCK_SCALE_MULTIPLIER);
                        rot.scale((float)(1 - axis.getX()) * scale + 1.0f, (float)(1 - axis.getY()) * scale + 1.0f, (float)(1 - axis.getZ()) * scale + 1.0f);
                    }
                    rot.translate(origin.getX(), origin.getY(), origin.getZ());
                }
                element.rotationMatrix = rot;
            } else {
                element.rotationMatrix = new MatrixM4f();
            }
            boolean allDirs = true;
            for (Direction direction : Direction.values()) {
                ConfigurationNode faceNode = node.node("faces", direction.name().toLowerCase());
                if (!faceNode.virtual()) {
                    try {
                        Element.Face face = this.buildFace(element, direction, faceNode);
                        element.faces.put(direction, face);
                        continue;
                    }
                    catch (ParseResourceException | IOException ex) {
                        throw new ParseResourceException("Failed to parse an " + (Object)((Object)direction) + " face for the model " + topModelPath + "!", ex);
                    }
                }
                allDirs = false;
            }
            if (fullElement && allDirs) {
                element.fullCube = true;
            }
            return element;
        }

        private Element.Face buildFace(Element element, Direction direction, ConfigurationNode node) throws ParseResourceException, IOException {
            try {
                Element element2 = element;
                Objects.requireNonNull(element2);
                Element.Face face = element2.new Element.Face(direction);
                if (!node.node("uv").virtual()) {
                    face.uv = this.readVector4f(node.node("uv"));
                }
                face.texture = this.getTexture(node.node("texture").getString(""));
                face.tinted = node.node("tintindex").getInt(-1) >= 0;
                face.rotation = node.node("rotation").getInt(0);
                if (!node.node("cullface").virtual()) {
                    String dirString = node.node("cullface").getString("");
                    if (dirString.equals("bottom")) {
                        dirString = "down";
                    }
                    if (dirString.equals("top")) {
                        dirString = "up";
                    }
                    try {
                        face.cullface = Direction.fromString(dirString);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return face;
            }
            catch (FileNotFoundException ex) {
                throw new ParseResourceException("There is no texture with the path: " + node.node("texture").getString(), ex);
            }
            catch (NoSuchElementException ex) {
                throw new ParseResourceException("Texture key '" + node.node("texture").getString() + "' has no texture assigned!", ex);
            }
        }

        private Vector3f readVector3f(ConfigurationNode node) throws ParseResourceException {
            List<? extends ConfigurationNode> nodeList = node.childrenList();
            if (nodeList.size() < 3) {
                throw new ParseResourceException("Failed to load Vector3: Not enough values in list-node!");
            }
            return new Vector3f(nodeList.get(0).getFloat(0.0f), nodeList.get(1).getFloat(0.0f), nodeList.get(2).getFloat(0.0f));
        }

        private Vector4f readVector4f(ConfigurationNode node) throws ParseResourceException {
            List<? extends ConfigurationNode> nodeList = node.childrenList();
            if (nodeList.size() < 4) {
                throw new ParseResourceException("Failed to load Vector4: Not enough values in list-node!");
            }
            return new Vector4f(nodeList.get(0).getFloat(0.0f), nodeList.get(1).getFloat(0.0f), nodeList.get(2).getFloat(0.0f), nodeList.get(3).getFloat(0.0f));
        }

        private Texture getTexture(String key) throws NoSuchElementException, FileNotFoundException, IOException {
            return this.getTexture(key, 0);
        }

        private Texture getTexture(String key, int depth) throws NoSuchElementException, FileNotFoundException, IOException {
            Texture texture;
            if (key.isEmpty() || key.equals("#")) {
                throw new NoSuchElementException("Empty texture key or name!");
            }
            if (depth > 10) {
                throw new NoSuchElementException("Recursive texture-variable!");
            }
            if (key.charAt(0) == '#') {
                String value = this.textures.get(key.substring(1));
                if (value == null) {
                    throw new NoSuchElementException("There is no texture defined for the key " + key);
                }
                return this.getTexture(value, depth + 1);
            }
            String path = ResourcePack.namespacedToAbsoluteResourcePath(key, "textures") + ".png";
            try {
                texture = this.resourcePack.getTextures().get(path);
            }
            catch (NoSuchElementException ex) {
                texture = this.resourcePack.getTextures().loadTexture(this.sourcesAccess, path);
            }
            return texture;
        }
    }

    public class Element {
        private Vector3f from = Vector3f.ZERO;
        private Vector3f to = new Vector3f(16.0f, 16.0f, 16.0f);
        private Rotation rotation = new Rotation();
        private MatrixM4f rotationMatrix;
        private boolean shade = true;
        private EnumMap<Direction, Face> faces = new EnumMap(Direction.class);
        private boolean fullCube = false;

        private Element() {
        }

        public Vector4f getDefaultUV(Direction face) {
            switch (face) {
                case DOWN: 
                case UP: {
                    return new Vector4f(this.from.getX(), this.from.getZ(), this.to.getX(), this.to.getZ());
                }
                case NORTH: 
                case SOUTH: {
                    return new Vector4f(this.from.getX(), this.from.getY(), this.to.getX(), this.to.getY());
                }
                case WEST: 
                case EAST: {
                    return new Vector4f(this.from.getZ(), this.from.getY(), this.to.getZ(), this.to.getY());
                }
            }
            return new Vector4f(0.0f, 0.0f, 16.0f, 16.0f);
        }

        public BlockModelResource getModel() {
            return BlockModelResource.this;
        }

        public Vector3f getFrom() {
            return this.from;
        }

        public Vector3f getTo() {
            return this.to;
        }

        public Rotation getRotation() {
            return this.rotation;
        }

        public MatrixM4f getRotationMatrix() {
            return this.rotationMatrix;
        }

        public boolean isShade() {
            return this.shade;
        }

        public boolean isFullCube() {
            return this.fullCube;
        }

        public EnumMap<Direction, Face> getFaces() {
            return this.faces;
        }

        public class Rotation {
            private Vector3f origin = new Vector3f(8.0f, 8.0f, 8.0f);
            private Axis axis = Axis.Y;
            private float angle = 0.0f;
            private boolean rescale = false;

            private Rotation() {
            }

            public Vector3f getOrigin() {
                return this.origin;
            }

            public Axis getAxis() {
                return this.axis;
            }

            public float getAngle() {
                return this.angle;
            }

            public boolean isRescale() {
                return this.rescale;
            }
        }

        public class Face {
            private Vector4f uv;
            private Texture texture;
            private Direction cullface;
            private int rotation = 0;
            private boolean tinted = false;

            private Face(Direction dir) {
                this.uv = Element.this.getDefaultUV(dir);
            }

            public Element getElement() {
                return Element.this;
            }

            public Vector4f getUv() {
                return this.uv;
            }

            public Texture getTexture() {
                return this.texture;
            }

            public Direction getCullface() {
                return this.cullface;
            }

            public int getRotation() {
                return this.rotation;
            }

            public boolean isTinted() {
                return this.tinted;
            }
        }
    }
}

