/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack;

import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resourcepack.BiomeConfig;
import de.bluecolored.bluemap.core.resourcepack.BlockColorCalculatorFactory;
import de.bluecolored.bluemap.core.resourcepack.BlockPropertiesConfig;
import de.bluecolored.bluemap.core.resourcepack.NoSuchResourceException;
import de.bluecolored.bluemap.core.resourcepack.ParseResourceException;
import de.bluecolored.bluemap.core.resourcepack.blockmodel.BlockModelResource;
import de.bluecolored.bluemap.core.resourcepack.blockmodel.TransformedBlockModelResource;
import de.bluecolored.bluemap.core.resourcepack.blockstate.BlockStateResource;
import de.bluecolored.bluemap.core.resourcepack.fileaccess.BluemapAssetOverrideFileAccess;
import de.bluecolored.bluemap.core.resourcepack.fileaccess.CaseInsensitiveFileAccess;
import de.bluecolored.bluemap.core.resourcepack.fileaccess.CombinedFileAccess;
import de.bluecolored.bluemap.core.resourcepack.fileaccess.FileAccess;
import de.bluecolored.bluemap.core.resourcepack.texture.TextureGallery;
import de.bluecolored.bluemap.core.util.Tristate;
import de.bluecolored.bluemap.core.world.Biome;
import de.bluecolored.bluemap.core.world.BlockProperties;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.shadow.benmanes.caffeine.cache.Caffeine;
import de.bluecolored.shadow.benmanes.caffeine.cache.LoadingCache;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.output.ByteArrayOutputStream;

@DebugDump
public class ResourcePack {
    private final Map<String, BlockStateResource> blockStateResources = new HashMap<String, BlockStateResource>();
    private final Map<String, BlockModelResource> blockModelResources = new HashMap<String, BlockModelResource>();
    private final TextureGallery textures = new TextureGallery();
    private final BlockPropertiesConfig blockPropertiesConfig = new BlockPropertiesConfig();
    private final BiomeConfig biomeConfig = new BiomeConfig();
    private final BlockColorCalculatorFactory blockColorCalculatorFactory = new BlockColorCalculatorFactory();
    private final LoadingCache<BlockState, BlockProperties> blockPropertiesCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).maximumSize(10000L).build(this::getBlockPropertiesNoCache);

    public void load(Collection<File> sources) throws IOException, InterruptedException {
        this.load(sources.toArray(new File[0]));
    }

    public void load(File ... sources) throws InterruptedException {
        try (CombinedFileAccess combinedSources = new CombinedFileAccess();){
            for (File file : sources) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                try {
                    combinedSources.addFileAccess(FileAccess.of(file));
                }
                catch (IOException e) {
                    Logger.global.logError("Failed to read ResourcePack: " + file, e);
                }
            }
            CaseInsensitiveFileAccess sourcesAccess = new CaseInsensitiveFileAccess(new BluemapAssetOverrideFileAccess(combinedSources));
            this.textures.reloadAllTextures(sourcesAccess);
            BlockStateResource.Builder builder = BlockStateResource.builder(sourcesAccess, this);
            Collection<String> namespaces = sourcesAccess.listFolders("assets");
            int i = 0;
            for (String namespaceRoot : namespaces) {
                GsonConfigurationLoader loader;
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                String namespace = namespaceRoot.substring("assets/".length());
                Logger.global.logInfo("Loading " + namespace + " assets (" + ++i + "/" + namespaces.size() + ")...");
                String blockstatesRootPath = namespaceRoot + "/blockstates";
                Collection<String> blockstateFiles = sourcesAccess.listFiles(blockstatesRootPath, true);
                for (String blockstateFile : blockstateFiles) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    String filename = blockstateFile.substring(blockstatesRootPath.length() + 1);
                    if (!filename.endsWith(".json")) continue;
                    String jsonFileName = filename.substring(0, filename.length() - 5);
                    try {
                        this.blockStateResources.put(namespace + ":" + jsonFileName, builder.build(blockstateFile));
                    }
                    catch (IOException ex) {
                        Logger.global.logError("Failed to load blockstate: " + namespace + ":" + jsonFileName, ex);
                    }
                }
                try {
                    loader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().source(() -> new BufferedReader(new InputStreamReader(sourcesAccess.readFile("assets/" + namespace + "/biomes.json"))))).build();
                    this.biomeConfig.load((ConfigurationNode)loader.load());
                }
                catch (IOException ex) {
                    Logger.global.logError("Failed to load biomes.conf from: " + namespace, ex);
                }
                try {
                    loader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().source(() -> new BufferedReader(new InputStreamReader(sourcesAccess.readFile("assets/" + namespace + "/blockProperties.json"))))).build();
                    this.blockPropertiesConfig.load((ConfigurationNode)loader.load());
                }
                catch (IOException ex) {
                    Logger.global.logError("Failed to load biomes.conf from: " + namespace, ex);
                }
                try {
                    loader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().source(() -> new BufferedReader(new InputStreamReader(sourcesAccess.readFile("assets/" + namespace + "/blockColors.json"))))).build();
                    this.blockColorCalculatorFactory.load((ConfigurationNode)loader.load());
                }
                catch (IOException ex) {
                    Logger.global.logError("Failed to load biomes.conf from: " + namespace, ex);
                }
            }
            try {
                this.blockColorCalculatorFactory.setFoliageMap(ImageIO.read(sourcesAccess.readFile("assets/minecraft/textures/colormap/foliage.png")));
            }
            catch (IOException | ArrayIndexOutOfBoundsException ex) {
                Logger.global.logError("Failed to load foliagemap!", ex);
            }
            try {
                this.blockColorCalculatorFactory.setGrassMap(ImageIO.read(sourcesAccess.readFile("assets/minecraft/textures/colormap/grass.png")));
            }
            catch (IOException | ArrayIndexOutOfBoundsException ex) {
                Logger.global.logError("Failed to load grassmap!", ex);
            }
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to close FileAccess!", ex);
        }
    }

    public void loadTextureFile(File file) throws IOException, ParseResourceException {
        this.textures.loadTextureFile(file);
    }

    public void saveTextureFile(File file) throws IOException {
        this.textures.saveTextureFile(file);
    }

    public BlockStateResource getBlockStateResource(BlockState state) throws NoSuchResourceException {
        BlockStateResource resource = this.blockStateResources.get(state.getFullId());
        if (resource == null) {
            throw new NoSuchResourceException("No resource for blockstate: " + state.getFullId());
        }
        return resource;
    }

    public BlockProperties getBlockProperties(BlockState state) {
        return this.blockPropertiesCache.get(state);
    }

    private BlockProperties getBlockPropertiesNoCache(BlockState state) {
        BlockProperties.Builder props = this.blockPropertiesConfig.getBlockProperties(state).toBuilder();
        if (props.isOccluding() == Tristate.UNDEFINED || props.isCulling() == Tristate.UNDEFINED) {
            try {
                BlockStateResource resource = this.getBlockStateResource(state);
                for (TransformedBlockModelResource bmr : resource.getModels(state, new ArrayList<TransformedBlockModelResource>())) {
                    if (props.isOccluding() == Tristate.UNDEFINED) {
                        props.occluding(bmr.getModel().isOccluding());
                    }
                    if (props.isCulling() != Tristate.UNDEFINED) continue;
                    props.culling(bmr.getModel().isCulling());
                }
            }
            catch (NoSuchResourceException noSuchResourceException) {
                // empty catch block
            }
        }
        return props.build();
    }

    public Biome getBiome(int id) {
        return this.biomeConfig.getBiome(id);
    }

    public Map<String, BlockStateResource> getBlockStateResources() {
        return this.blockStateResources;
    }

    public Map<String, BlockModelResource> getBlockModelResources() {
        return this.blockModelResources;
    }

    public TextureGallery getTextures() {
        return this.textures;
    }

    public BlockColorCalculatorFactory getBlockColorCalculatorFactory() {
        return this.blockColorCalculatorFactory;
    }

    public static String namespacedToAbsoluteResourcePath(String namespacedPath, String resourceTypeFolder) {
        String path = namespacedPath;
        resourceTypeFolder = FileAccess.normalize(resourceTypeFolder);
        int namespaceIndex = path.indexOf(58);
        String namespace = "minecraft";
        if (namespaceIndex != -1) {
            namespace = path.substring(0, namespaceIndex);
            path = path.substring(namespaceIndex + 1);
        }
        path = resourceTypeFolder.isEmpty() ? "assets/" + namespace + "/" + FileAccess.normalize(path) : "assets/" + namespace + "/" + resourceTypeFolder + "/" + FileAccess.normalize(path);
        return path;
    }

    public static class Resource {
        private final byte[] data;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Resource(InputStream data) throws IOException {
            try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
                bout.write(data);
                this.data = bout.toByteArray();
            }
            finally {
                data.close();
            }
        }

        public InputStream read() {
            return new ByteArrayInputStream(this.data);
        }
    }
}

