/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resourcepack.BlockStateMapping;
import de.bluecolored.bluemap.core.world.BlockProperties;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class BlockPropertiesConfig {
    private final Map<String, List<BlockStateMapping<BlockProperties>>> mappings = new ConcurrentHashMap<String, List<BlockStateMapping<BlockProperties>>>();

    public void load(ConfigurationNode node) {
        for (Map.Entry<Object, ? extends ConfigurationNode> e : node.childrenMap().entrySet()) {
            String key = e.getKey().toString();
            try {
                BlockState bsKey = BlockState.fromString(key);
                BlockProperties.Builder bsValueBuilder = BlockProperties.builder();
                this.readBool(e.getValue().node("culling"), bsValueBuilder::culling);
                this.readBool(e.getValue().node("occluding"), bsValueBuilder::occluding);
                this.readBool(e.getValue().node("alwaysWaterlogged"), bsValueBuilder::alwaysWaterlogged);
                this.readBool(e.getValue().node("randomOffset"), bsValueBuilder::randomOffset);
                BlockStateMapping<BlockProperties> mapping = new BlockStateMapping<BlockProperties>(bsKey, bsValueBuilder.build());
                this.mappings.computeIfAbsent(bsKey.getFullId(), k -> new LinkedList()).add(0, mapping);
            }
            catch (IllegalArgumentException ex) {
                Logger.global.logWarning("Loading BlockPropertiesConfig: Failed to parse BlockState from key '" + key + "'");
            }
        }
    }

    private void readBool(ConfigurationNode node, Consumer<Boolean> target) {
        if (!node.virtual()) {
            target.accept(node.getBoolean());
        }
    }

    public BlockProperties getBlockProperties(BlockState from) {
        for (BlockStateMapping bm : this.mappings.getOrDefault(from.getFullId(), Collections.emptyList())) {
            if (!bm.fitsTo(from)) continue;
            return (BlockProperties)bm.getMapping();
        }
        return BlockProperties.DEFAULT;
    }
}

