/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack;

import com.flowpowered.math.GenericMath;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.bluemap.core.util.ConfigUtils;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.Biome;
import de.bluecolored.bluemap.core.world.BlockNeighborhood;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

@DebugDump
public class BlockColorCalculatorFactory {
    private final int[] foliageMap = new int[65536];
    private final int[] grassMap = new int[65536];
    private final Map<String, ColorFunction> blockColorMap = new HashMap<String, ColorFunction>();

    public void load(ConfigurationNode colorConfig) {
        for (Map.Entry<Object, ? extends ConfigurationNode> entry : colorConfig.childrenMap().entrySet()) {
            ColorFunction colorFunction;
            String value;
            String key = entry.getKey().toString();
            switch (value = entry.getValue().getString("")) {
                case "@foliage": {
                    colorFunction = BlockColorCalculator::getFoliageAverageColor;
                    break;
                }
                case "@grass": {
                    colorFunction = BlockColorCalculator::getGrassAverageColor;
                    break;
                }
                case "@water": {
                    colorFunction = BlockColorCalculator::getWaterAverageColor;
                    break;
                }
                case "@redstone": {
                    colorFunction = BlockColorCalculator::getRedstoneColor;
                    break;
                }
                default: {
                    Color color = new Color();
                    color.set(ConfigUtils.readColorInt(entry.getValue())).premultiplied();
                    colorFunction = (calculator, block, target) -> target.set(color);
                }
            }
            this.blockColorMap.put(key, colorFunction);
        }
    }

    public void setFoliageMap(BufferedImage foliageMap) {
        foliageMap.getRGB(0, 0, 256, 256, this.foliageMap, 0, 256);
    }

    public void setGrassMap(BufferedImage grassMap) {
        grassMap.getRGB(0, 0, 256, 256, this.grassMap, 0, 256);
    }

    public BlockColorCalculator createCalculator() {
        return new BlockColorCalculator();
    }

    @FunctionalInterface
    private static interface ColorFunction {
        public Color invoke(BlockColorCalculator var1, BlockNeighborhood var2, Color var3);
    }

    public class BlockColorCalculator {
        private final Color tempColor = new Color();

        public Color getBlockColor(BlockNeighborhood block, Color target) {
            String blockId = block.getBlockState().getFullId();
            ColorFunction colorFunction = (ColorFunction)BlockColorCalculatorFactory.this.blockColorMap.get(blockId);
            if (colorFunction == null) {
                colorFunction = (ColorFunction)BlockColorCalculatorFactory.this.blockColorMap.get("default");
            }
            if (colorFunction == null) {
                colorFunction = BlockColorCalculator::getFoliageAverageColor;
            }
            return colorFunction.invoke(this, block, target);
        }

        public Color getRedstoneColor(BlockNeighborhood block, Color target) {
            String powerString = block.getBlockState().getProperties().get("power");
            int power = 15;
            if (powerString != null) {
                power = Integer.parseInt(powerString);
            }
            return target.set(((float)power + 5.0f) / 20.0f, 0.0f, 0.0f, 1.0f, true);
        }

        public Color getWaterAverageColor(BlockNeighborhood block, Color target) {
            target.set(0.0f, 0.0f, 0.0f, 0.0f, true);
            int minX = -2;
            int maxX = 2;
            int minY = -1;
            int maxY = 1;
            int minZ = -2;
            int maxZ = 2;
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Biome biome = block.getNeighborBlock(x, y, z).getBiome();
                        target.add(biome.getWaterColor());
                    }
                }
            }
            return target.flatten();
        }

        public Color getFoliageAverageColor(BlockNeighborhood block, Color target) {
            target.set(0.0f, 0.0f, 0.0f, 0.0f, true);
            int minX = -2;
            int maxX = 2;
            int minY = -1;
            int maxY = 1;
            int minZ = -2;
            int maxZ = 2;
            for (int y = minY; y <= maxY; ++y) {
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Biome biome = block.getNeighborBlock(x, y, z).getBiome();
                        target.add(this.getFoliageColor(biome, this.tempColor));
                    }
                }
            }
            return target.flatten();
        }

        public Color getFoliageColor(Biome biome, Color target) {
            this.getColorFromMap(biome, BlockColorCalculatorFactory.this.foliageMap, 4764952, target);
            return target.overlay(biome.getOverlayFoliageColor());
        }

        public Color getGrassAverageColor(BlockNeighborhood block, Color target) {
            target.set(0.0f, 0.0f, 0.0f, 0.0f, true);
            int minX = -2;
            int maxX = 2;
            int minY = -1;
            int maxY = 1;
            int minZ = -2;
            int maxZ = 2;
            for (int y = minY; y <= maxY; ++y) {
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Biome biome = block.getNeighborBlock(x, y, z).getBiome();
                        target.add(this.getGrassColor(biome, this.tempColor));
                    }
                }
            }
            return target.flatten();
        }

        public Color getGrassColor(Biome biome, Color target) {
            this.getColorFromMap(biome, BlockColorCalculatorFactory.this.grassMap, -11365073, target);
            return target.overlay(biome.getOverlayGrassColor());
        }

        private void getColorFromMap(Biome biome, int[] colorMap, int defaultColor, Color target) {
            int x;
            double temperature = GenericMath.clamp(biome.getTemp(), 0.0, 1.0);
            double humidity = GenericMath.clamp(biome.getHumidity(), 0.0, 1.0) * temperature;
            int y = (int)((1.0 - humidity) * 255.0);
            int index = y << 8 | (x = (int)((1.0 - temperature) * 255.0));
            int color = index >= colorMap.length ? defaultColor : colorMap[index];
            target.set(color);
        }
    }
}

