/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resourcepack;

import de.bluecolored.bluemap.core.world.Biome;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import java.util.Map;

public class BiomeConfig {
    private Biome[] biomes = new Biome[10];

    public void load(ConfigurationNode node) {
        for (Map.Entry<Object, ? extends ConfigurationNode> e : node.childrenMap().entrySet()) {
            String id = e.getKey().toString();
            Biome biome = Biome.create(id, e.getValue());
            int numeralId = biome.getNumeralId();
            this.ensureAvailability(numeralId);
            this.biomes[numeralId] = biome;
        }
    }

    public Biome getBiome(int id) {
        if (id < this.biomes.length) {
            Biome biome = this.biomes[id];
            return biome != null ? biome : Biome.DEFAULT;
        }
        return Biome.DEFAULT;
    }

    private void ensureAvailability(int id) {
        if (id >= this.biomes.length) {
            int newSize = this.biomes.length;
            while (id >= (newSize = (int)((double)newSize * 1.5) + 1)) {
            }
            Biome[] newArray = new Biome[newSize];
            System.arraycopy(this.biomes, 0, newArray, 0, this.biomes.length);
            this.biomes = newArray;
        }
    }
}

