/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.model;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.imaginary.Quaternionf;
import com.flowpowered.math.vector.Vector3f;
import de.bluecolored.bluemap.core.model.MatrixM3f;

@Deprecated
public class VectorM3f {
    public float x;
    public float y;
    public float z;

    public VectorM3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public VectorM3f(VectorM3f v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public VectorM3f(Vector3f v) {
        this.x = v.getX();
        this.y = v.getY();
        this.z = v.getZ();
    }

    public void set(Vector3f v) {
        this.x = v.getX();
        this.y = v.getY();
        this.z = v.getZ();
    }

    public void add(VectorM3f translation) {
        this.x += translation.x;
        this.y += translation.y;
        this.z += translation.z;
    }

    public void add(Vector3f translation) {
        this.x += translation.getX();
        this.y += translation.getY();
        this.z += translation.getZ();
    }

    public void rotate(Quaternionf rotation) {
        float length = rotation.length();
        if (Math.abs(length) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot rotate by the zero quaternion");
        }
        float nx = rotation.getX() / length;
        float ny = rotation.getY() / length;
        float nz = rotation.getZ() / length;
        float nw = rotation.getW() / length;
        float px = nw * this.x + ny * this.z - nz * this.y;
        float py = nw * this.y + nz * this.x - nx * this.z;
        float pz = nw * this.z + nx * this.y - ny * this.x;
        float pw = -nx * this.x - ny * this.y - nz * this.z;
        this.x = pw * -nx + px * nw - py * nz + pz * ny;
        this.y = pw * -ny + py * nw - pz * nx + px * nz;
        this.z = pw * -nz + pz * nw - px * ny + py * nx;
    }

    public void transform(MatrixM3f t) {
        float lx = this.x;
        float ly = this.y;
        this.x = t.m00 * lx + t.m01 * ly + t.m02 * this.z;
        this.y = t.m10 * lx + t.m11 * ly + t.m12 * this.z;
        this.z = t.m20 * lx + t.m21 * ly + t.m22 * this.z;
    }

    public void normalize() {
        float length = this.length();
        if (Math.abs(length) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero vector");
        }
        this.x /= length;
        this.y /= length;
        this.z /= length;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3f toVector3f() {
        return new Vector3f(this.x, this.y, this.z);
    }
}

