/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.model;

import com.flowpowered.math.imaginary.Quaternionf;
import com.flowpowered.math.matrix.Matrix3f;
import com.flowpowered.math.vector.Vector2f;
import com.flowpowered.math.vector.Vector3f;
import de.bluecolored.bluemap.core.model.Face;
import de.bluecolored.bluemap.core.threejs.BufferGeometry;
import de.bluecolored.bluemap.core.threejs.MaterialGroup;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class Model<T extends Face> {
    private List<T> faces = new ArrayList<T>();

    public void merge(Model<T> model) {
        this.faces.addAll(model.getFaces());
    }

    public void addFace(T face) {
        this.faces.add(face);
    }

    public void removeFace(T face) {
        this.faces.remove(face);
    }

    public List<T> getFaces() {
        return this.faces;
    }

    public void rotate(Quaternionf rotation) {
        for (Face f : this.faces) {
            f.rotate(rotation);
        }
    }

    public void transform(Matrix3f transformation) {
        for (Face f : this.faces) {
            f.transform(transformation);
        }
    }

    public void translate(Vector3f translation) {
        for (Face f : this.faces) {
            f.translate(translation);
        }
    }

    public BufferGeometry toBufferGeometry() {
        this.faces.sort((f1, f2) -> (int)Math.signum(f1.getMaterialIndex() - f2.getMaterialIndex()));
        int count = this.faces.size();
        ArrayList<MaterialGroup> groups = new ArrayList<MaterialGroup>();
        int groupStart = 0;
        int currentMaterialIndex = -1;
        if (count > 0) {
            currentMaterialIndex = ((Face)this.faces.get(0)).getMaterialIndex();
        }
        float[] position = new float[count * 3 * 3];
        float[] normal = new float[count * 3 * 3];
        float[] color = new float[count * 3 * 3];
        float[] uv = new float[count * 2 * 3];
        for (int itemIndex = 0; itemIndex < count; ++itemIndex) {
            Face f = (Face)this.faces.get(itemIndex);
            if (currentMaterialIndex != f.getMaterialIndex()) {
                groups.add(new MaterialGroup(currentMaterialIndex, groupStart * 3, (itemIndex - groupStart) * 3));
                groupStart = itemIndex;
                currentMaterialIndex = f.getMaterialIndex();
            }
            Model.addVector3fToArray(position, f.getP1(), (itemIndex * 3 + 0) * 3);
            Model.addVector3fToArray(normal, f.getN1(), (itemIndex * 3 + 0) * 3);
            Model.addVector3fToArray(color, f.getC1(), (itemIndex * 3 + 0) * 3);
            Model.addVector2fToArray(uv, f.getUv1(), (itemIndex * 3 + 0) * 2);
            Model.addVector3fToArray(position, f.getP2(), (itemIndex * 3 + 1) * 3);
            Model.addVector3fToArray(normal, f.getN2(), (itemIndex * 3 + 1) * 3);
            Model.addVector3fToArray(color, f.getC2(), (itemIndex * 3 + 1) * 3);
            Model.addVector2fToArray(uv, f.getUv2(), (itemIndex * 3 + 1) * 2);
            Model.addVector3fToArray(position, f.getP3(), (itemIndex * 3 + 2) * 3);
            Model.addVector3fToArray(normal, f.getN3(), (itemIndex * 3 + 2) * 3);
            Model.addVector3fToArray(color, f.getC3(), (itemIndex * 3 + 2) * 3);
            Model.addVector2fToArray(uv, f.getUv3(), (itemIndex * 3 + 2) * 2);
        }
        groups.add(new MaterialGroup(currentMaterialIndex, groupStart * 3, (count - groupStart) * 3));
        return new BufferGeometry(position, normal, color, uv, groups.toArray(new MaterialGroup[groups.size()]));
    }

    static void addVector3fToArray(float[] array, Vector3f v, int startIndex) {
        array[startIndex] = v.getX();
        array[startIndex + 1] = v.getY();
        array[startIndex + 2] = v.getZ();
    }

    static void addVector2fToArray(float[] array, Vector2f v, int startIndex) {
        array[startIndex] = v.getX();
        array[startIndex + 1] = v.getY();
    }
}

