/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.model;

import com.flowpowered.math.imaginary.Quaternionf;
import com.flowpowered.math.matrix.Matrix3f;
import com.flowpowered.math.vector.Vector2f;
import com.flowpowered.math.vector.Vector3f;
import de.bluecolored.bluemap.core.model.MatrixM3f;
import de.bluecolored.bluemap.core.model.VectorM3f;

@Deprecated
public class Face {
    private final VectorM3f p1;
    private final VectorM3f p2;
    private final VectorM3f p3;
    private final VectorM3f n1;
    private final VectorM3f n2;
    private final VectorM3f n3;
    private Vector3f c1;
    private Vector3f c2;
    private Vector3f c3;
    private Vector2f uv1;
    private Vector2f uv2;
    private Vector2f uv3;
    private int materialIndex;
    private boolean normalizedNormals;

    public Face(Vector3f p1, Vector3f p2, Vector3f p3, Vector2f uv1, Vector2f uv2, Vector2f uv3, int materialIndex) {
        Vector3f color;
        this.p1 = new VectorM3f(p1);
        this.p2 = new VectorM3f(p2);
        this.p3 = new VectorM3f(p3);
        this.uv1 = uv1;
        this.uv2 = uv2;
        this.uv3 = uv3;
        this.materialIndex = materialIndex;
        this.n1 = this.calculateSurfaceNormal(new VectorM3f(0.0f, 0.0f, 0.0f));
        this.n2 = new VectorM3f(this.n1);
        this.n3 = new VectorM3f(this.n1);
        this.normalizedNormals = true;
        this.c1 = color = Vector3f.ONE;
        this.c2 = color;
        this.c3 = color;
    }

    public void rotate(Quaternionf rotation) {
        this.p1.rotate(rotation);
        this.p2.rotate(rotation);
        this.p3.rotate(rotation);
        this.n1.rotate(rotation);
        this.n2.rotate(rotation);
        this.n3.rotate(rotation);
    }

    public void transform(Matrix3f transformation) {
        MatrixM3f mtransform = new MatrixM3f(transformation);
        this.p1.transform(mtransform);
        this.p2.transform(mtransform);
        this.p3.transform(mtransform);
        this.n1.transform(mtransform);
        this.n2.transform(mtransform);
        this.n3.transform(mtransform);
        this.normalizedNormals = false;
    }

    public void translate(Vector3f translation) {
        this.p1.add(translation);
        this.p2.add(translation);
        this.p3.add(translation);
    }

    public Vector3f getP1() {
        return this.p1.toVector3f();
    }

    public void setP1(Vector3f p1) {
        this.p1.set(p1);
    }

    public Vector3f getP2() {
        return this.p2.toVector3f();
    }

    public void setP2(Vector3f p2) {
        this.p2.set(p2);
    }

    public Vector3f getP3() {
        return this.p3.toVector3f();
    }

    public void setP3(Vector3f p3) {
        this.p3.set(p3);
    }

    public Vector3f getN1() {
        this.normalizeNormals();
        return this.n1.toVector3f();
    }

    public void setN1(Vector3f n1) {
        this.n1.set(n1);
        this.normalizedNormals = false;
    }

    public Vector3f getN2() {
        this.normalizeNormals();
        return this.n2.toVector3f();
    }

    public void setN2(Vector3f n2) {
        this.n2.set(n2);
        this.normalizedNormals = false;
    }

    public Vector3f getN3() {
        this.normalizeNormals();
        return this.n3.toVector3f();
    }

    public void setN3(Vector3f n3) {
        this.n3.set(n3);
        this.normalizedNormals = false;
    }

    public Vector3f getC1() {
        return this.c1;
    }

    public void setC1(Vector3f c1) {
        this.c1 = c1;
    }

    public Vector3f getC2() {
        return this.c2;
    }

    public void setC2(Vector3f c2) {
        this.c2 = c2;
    }

    public Vector3f getC3() {
        return this.c3;
    }

    public void setC3(Vector3f c3) {
        this.c3 = c3;
    }

    public Vector2f getUv1() {
        return this.uv1;
    }

    public void setUv1(Vector2f uv1) {
        this.uv1 = uv1;
    }

    public Vector2f getUv2() {
        return this.uv2;
    }

    public void setUv2(Vector2f uv2) {
        this.uv2 = uv2;
    }

    public Vector2f getUv3() {
        return this.uv3;
    }

    public void setUv3(Vector2f uv3) {
        this.uv3 = uv3;
    }

    public int getMaterialIndex() {
        return this.materialIndex;
    }

    public void setMaterialIndex(int materialIndex) {
        this.materialIndex = materialIndex;
    }

    private void normalizeNormals() {
        if (this.normalizedNormals) {
            return;
        }
        this.n1.normalize();
        this.n2.normalize();
        this.n3.normalize();
        this.normalizedNormals = true;
    }

    private VectorM3f calculateSurfaceNormal(VectorM3f target) {
        double p1x = this.p1.x;
        double p1y = this.p1.y;
        double p1z = this.p1.z;
        double p2x = this.p2.x;
        double p2y = this.p2.y;
        double p2z = this.p2.z;
        double p3x = this.p3.x;
        double p3y = this.p3.y;
        double p3z = this.p3.z;
        p2x -= p1x;
        p3x -= p1x;
        p1x = (p2y -= p1y) * (p3z -= p1z) - (p2z -= p1z) * (p3y -= p1y);
        p1y = p2z * p3x - p2x * p3z;
        p1z = p2x * p3y - p2y * p3x;
        double length = Math.sqrt(p1x * p1x + p1y * p1y + p1z * p1z);
        target.x = (float)(p1x /= length);
        target.y = (float)(p1y /= length);
        target.z = (float)(p1z /= length);
        return target;
    }
}

