/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.mca;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.mca.MCAChunk;
import de.bluecolored.bluemap.core.mca.MCARegion;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.Grid;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.shadow.benmanes.caffeine.cache.Caffeine;
import de.bluecolored.shadow.benmanes.caffeine.cache.LoadingCache;
import de.bluecolored.shadow.querz.nbt.CompoundTag;
import de.bluecolored.shadow.querz.nbt.NBTUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class MCAWorld
implements World {
    private static final Grid CHUNK_GRID = new Grid(16);
    private static final Grid REGION_GRID = new Grid(32).multiply(CHUNK_GRID);
    @DebugDump
    private final UUID uuid;
    @DebugDump
    private final Path worldFolder;
    @DebugDump
    private final String name;
    @DebugDump
    private final Vector3i spawnPoint;
    @DebugDump
    private final int skyLight;
    @DebugDump
    private final boolean ignoreMissingLightData;
    private final LoadingCache<Vector2i, MCARegion> regionCache;
    private final LoadingCache<Vector2i, MCAChunk> chunkCache;
    private static final int VEC_2I_CACHE_SIZE = 16384;
    private static final int VEC_2I_CACHE_MASK = 16383;
    private static final Vector2i[] VEC_2I_CACHE = new Vector2i[16384];

    private MCAWorld(Path worldFolder, UUID uuid, String name, Vector3i spawnPoint, int skyLight, boolean ignoreMissingLightData) {
        this.uuid = uuid;
        this.worldFolder = worldFolder;
        this.name = name;
        this.spawnPoint = spawnPoint;
        this.skyLight = skyLight;
        this.ignoreMissingLightData = ignoreMissingLightData;
        this.regionCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).maximumSize(100L).expireAfterWrite(1L, TimeUnit.MINUTES).build(this::loadRegion);
        this.chunkCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).maximumSize(500L).expireAfterWrite(1L, TimeUnit.MINUTES).build(this::loadChunk);
    }

    public BlockState getBlockState(Vector3i pos) {
        return this.getChunk(pos.getX() >> 4, pos.getZ() >> 4).getBlockState(pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public MCAChunk getChunkAtBlock(int x, int y, int z) {
        return this.getChunk(x >> 4, z >> 4);
    }

    @Override
    public MCAChunk getChunk(int x, int z) {
        return this.getChunk(MCAWorld.vec2i(x, z));
    }

    private MCAChunk getChunk(Vector2i pos) {
        return this.chunkCache.get(pos);
    }

    @Override
    public MCARegion getRegion(int x, int z) {
        return this.getRegion(MCAWorld.vec2i(x, z));
    }

    private MCARegion getRegion(Vector2i pos) {
        return this.regionCache.get(pos);
    }

    @Override
    public Collection<Vector2i> listRegions() {
        File[] regionFiles = this.getRegionFolder().toFile().listFiles();
        if (regionFiles == null) {
            return Collections.emptyList();
        }
        ArrayList<Vector2i> regions = new ArrayList<Vector2i>(regionFiles.length);
        for (File file : regionFiles) {
            if (!file.getName().endsWith(".mca") || file.length() <= 0L) continue;
            try {
                String[] filenameParts = file.getName().split("\\.");
                int rX = Integer.parseInt(filenameParts[1]);
                int rZ = Integer.parseInt(filenameParts[2]);
                regions.add(new Vector2i(rX, rZ));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return regions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Path getSaveFolder() {
        return this.worldFolder;
    }

    @Override
    public int getSkyLight() {
        return this.skyLight;
    }

    @Override
    public int getMinY(int x, int z) {
        return this.getChunk(x >> 4, z >> 4).getMinY(x, z);
    }

    @Override
    public int getMaxY(int x, int z) {
        return this.getChunk(x >> 4, z >> 4).getMaxY(x, z);
    }

    @Override
    public Grid getChunkGrid() {
        return CHUNK_GRID;
    }

    @Override
    public Grid getRegionGrid() {
        return REGION_GRID;
    }

    @Override
    public Vector3i getSpawnPoint() {
        return this.spawnPoint;
    }

    @Override
    public void invalidateChunkCache() {
        this.chunkCache.invalidateAll();
    }

    @Override
    public void invalidateChunkCache(int x, int z) {
        this.chunkCache.invalidate(MCAWorld.vec2i(x, z));
    }

    @Override
    public void cleanUpChunkCache() {
        this.chunkCache.cleanUp();
    }

    public Path getWorldFolder() {
        return this.worldFolder;
    }

    private Path getRegionFolder() {
        return this.worldFolder.resolve("region");
    }

    public boolean isIgnoreMissingLightData() {
        return this.ignoreMissingLightData;
    }

    private File getMCAFile(int regionX, int regionZ) {
        return this.getRegionFolder().resolve("r." + regionX + "." + regionZ + ".mca").toFile();
    }

    private MCARegion loadRegion(Vector2i regionPos) {
        return this.loadRegion(regionPos.getX(), regionPos.getY());
    }

    private MCARegion loadRegion(int x, int z) {
        File regionPath = this.getMCAFile(x, z);
        return new MCARegion(this, regionPath);
    }

    private MCAChunk loadChunk(Vector2i chunkPos) {
        return this.loadChunk(chunkPos.getX(), chunkPos.getY());
    }

    private MCAChunk loadChunk(int x, int z) {
        int tries = 3;
        int tryInterval = 1000;
        Exception loadException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.getRegion(x >> 5, z >> 5).loadChunk(x, z, this.ignoreMissingLightData);
            }
            catch (IOException | RuntimeException e) {
                if (loadException != null) {
                    e.addSuppressed(loadException);
                }
                loadException = e;
                if (i + 1 >= 3) continue;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        Logger.global.logDebug("Unexpected exception trying to load chunk (x:" + x + ", z:" + z + "):" + loadException);
        return MCAChunk.empty();
    }

    public static MCAWorld load(Path worldFolder, UUID uuid, String name, int skyLight, boolean ignoreMissingLightData) throws IOException {
        try {
            StringBuilder subDimensionName = new StringBuilder();
            File levelFolder = worldFolder.toFile();
            File levelFile = new File(levelFolder, "level.dat");
            int searchDepth = 0;
            while (!levelFile.exists() && searchDepth < 4) {
                ++searchDepth;
                subDimensionName.insert(0, "/").insert(1, levelFolder.getName());
                levelFolder = levelFolder.getParentFile();
                if (levelFolder == null) break;
                levelFile = new File(levelFolder, "level.dat");
            }
            if (!levelFile.exists()) {
                throw new FileNotFoundException("Could not find a level.dat file for this world!");
            }
            CompoundTag level = (CompoundTag)NBTUtil.readTag(levelFile);
            CompoundTag levelData = level.getCompoundTag("Data");
            if (name == null) {
                name = levelData.getString("LevelName") + subDimensionName;
            }
            Vector3i spawnPoint = new Vector3i(levelData.getInt("SpawnX"), levelData.getInt("SpawnY"), levelData.getInt("SpawnZ"));
            return new MCAWorld(worldFolder, uuid, name, spawnPoint, skyLight, ignoreMissingLightData);
        }
        catch (ClassCastException | NullPointerException ex) {
            throw new IOException("Invaid level.dat format!", ex);
        }
    }

    public String toString() {
        return "MCAWorld{uuid=" + this.uuid + ", worldFolder=" + this.worldFolder + ", name='" + this.name + '\'' + '}';
    }

    private static Vector2i vec2i(int x, int y) {
        int cacheIndex = (x * 1456 ^ y * 948375892) & 0x3FFF;
        Vector2i possibleMatch = VEC_2I_CACHE[cacheIndex];
        if (possibleMatch != null && possibleMatch.getX() == x && possibleMatch.getY() == y) {
            return possibleMatch;
        }
        MCAWorld.VEC_2I_CACHE[cacheIndex] = new Vector2i(x, y);
        return MCAWorld.VEC_2I_CACHE[cacheIndex];
    }
}

