/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.mca;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.mca.MCAChunk;
import de.bluecolored.bluemap.core.mca.MCAWorld;
import de.bluecolored.bluemap.core.world.Region;
import de.bluecolored.shadow.querz.nbt.CompoundTag;
import de.bluecolored.shadow.querz.nbt.Tag;
import de.bluecolored.shadow.querz.nbt.mca.CompressionType;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class MCARegion
implements Region {
    private final MCAWorld world;
    private final File regionFile;
    private final Vector2i regionPos;

    public MCARegion(MCAWorld world, File regionFile) throws IllegalArgumentException {
        this.world = world;
        this.regionFile = regionFile;
        String[] filenameParts = regionFile.getName().split("\\.");
        int rX = Integer.parseInt(filenameParts[1]);
        int rZ = Integer.parseInt(filenameParts[2]);
        this.regionPos = new Vector2i(rX, rZ);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MCAChunk loadChunk(int chunkX, int chunkZ, boolean ignoreMissingLightData) throws IOException {
        if (!this.regionFile.exists()) return MCAChunk.empty();
        if (this.regionFile.length() == 0L) {
            return MCAChunk.empty();
        }
        try (RandomAccessFile raf = new RandomAccessFile(this.regionFile, "r");){
            String string;
            int xzChunk = Math.floorMod(chunkZ, 32) * 32 + Math.floorMod(chunkX, 32);
            raf.seek(xzChunk * 4);
            int offset = raf.read() << 16;
            offset |= (raf.read() & 0xFF) << 8;
            offset |= raf.read() & 0xFF;
            offset *= 4096;
            int size = raf.readByte() * 4096;
            if (size == 0) {
                MCAChunk mCAChunk = MCAChunk.empty();
                return mCAChunk;
            }
            raf.seek(offset + 4);
            byte compressionTypeByte = raf.readByte();
            CompressionType compressionType = CompressionType.getFromID(compressionTypeByte);
            if (compressionType == null) {
                throw new IOException("Invalid compression type " + compressionTypeByte);
            }
            DataInputStream dis = new DataInputStream(new BufferedInputStream(compressionType.decompress(new FileInputStream(raf.getFD()))));
            Tag<?> tag = Tag.deserialize(dis, 512);
            if (tag instanceof CompoundTag) {
                MCAChunk chunk = MCAChunk.create(this.world, (CompoundTag)tag);
                if (!chunk.isGenerated()) {
                    MCAChunk mCAChunk = MCAChunk.empty();
                    return mCAChunk;
                }
                MCAChunk mCAChunk = chunk;
                return mCAChunk;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Invalid data tag: ");
            if (tag == null) {
                string = "null";
                throw new IOException(stringBuilder.append(string).toString());
            }
            string = tag.getClass().getName();
            throw new IOException(stringBuilder.append(string).toString());
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Collection<Vector2i> listChunks(long modifiedSince) {
        if (!this.regionFile.exists() || this.regionFile.length() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<Vector2i> chunks = new ArrayList<Vector2i>(1024);
        try (RandomAccessFile raf = new RandomAccessFile(this.regionFile, "r");){
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    Vector2i chunk = new Vector2i(this.regionPos.getX() * 32 + x, this.regionPos.getY() * 32 + z);
                    int xzChunk = z * 32 + x;
                    raf.seek(xzChunk * 4 + 3);
                    int size = raf.readByte() * 4096;
                    if (size == 0) continue;
                    raf.seek(xzChunk * 4 + 4096);
                    int timestamp = raf.read() << 24;
                    timestamp |= (raf.read() & 0xFF) << 16;
                    timestamp |= (raf.read() & 0xFF) << 8;
                    if ((long)(timestamp |= raf.read() & 0xFF) < modifiedSince / 1000L) continue;
                    chunks.add(chunk);
                }
            }
        }
        catch (IOException | RuntimeException ex) {
            Logger.global.logWarning("Failed to read .mca file: " + this.regionFile.getAbsolutePath() + " (" + ex.toString() + ")");
        }
        return chunks;
    }

    @Override
    public File getRegionFile() {
        return this.regionFile;
    }
}

