/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.lowres;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3f;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.hires.HiresTileMeta;
import de.bluecolored.bluemap.core.map.lowres.LowresModel;
import de.bluecolored.bluemap.core.threejs.BufferGeometry;
import de.bluecolored.bluemap.core.util.FileUtils;
import de.bluecolored.bluemap.core.util.math.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class LowresModelManager {
    private final Path fileRoot;
    private final Vector2i pointsPerLowresTile;
    private final Vector2i pointsPerHiresTile;
    private final boolean useGzip;
    private final Map<File, CachedModel> models;

    public LowresModelManager(Path fileRoot, Vector2i pointsPerLowresTile, Vector2i pointsPerHiresTile, boolean useGzip) {
        this.fileRoot = fileRoot;
        this.pointsPerLowresTile = pointsPerLowresTile;
        this.pointsPerHiresTile = pointsPerHiresTile;
        this.models = new ConcurrentHashMap<File, CachedModel>();
        this.useGzip = useGzip;
    }

    public void render(HiresTileMeta tileMeta) {
        Vector2i blocksPerPoint = new Vector2i(tileMeta.getSizeX() / this.pointsPerHiresTile.getX(), tileMeta.getSizeZ() / this.pointsPerHiresTile.getY());
        Vector2i pointMin = new Vector2i(Math.floorDiv(tileMeta.getMinX(), blocksPerPoint.getX()), Math.floorDiv(tileMeta.getMinZ(), blocksPerPoint.getY()));
        Color pointColor = new Color();
        Color columnColor = new Color();
        for (int tx = 0; tx < this.pointsPerHiresTile.getX(); ++tx) {
            for (int tz = 0; tz < this.pointsPerHiresTile.getY(); ++tz) {
                double height = 0.0;
                pointColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
                for (int x = 0; x < blocksPerPoint.getX(); ++x) {
                    for (int z = 0; z < blocksPerPoint.getY(); ++z) {
                        int rx = tx * blocksPerPoint.getX() + x + tileMeta.getMinX();
                        int rz = tz * blocksPerPoint.getY() + z + tileMeta.getMinZ();
                        height += (double)tileMeta.getHeight(rx, rz);
                        tileMeta.getColor(rx, rz, columnColor).premultiplied();
                        pointColor.add(columnColor);
                    }
                }
                pointColor.flatten().straight();
                int count = blocksPerPoint.getX() * blocksPerPoint.getY();
                this.update(pointMin.getX() + tx, pointMin.getY() + tz, (float)(height /= (double)count), pointColor);
            }
        }
    }

    public synchronized void save() {
        for (Map.Entry<File, CachedModel> entry : this.models.entrySet()) {
            this.saveModel(entry.getKey(), entry.getValue());
        }
        this.tidyUpModelCache();
    }

    public void update(int px, int pz, float height, Color color) {
        LowresModel model2;
        Vector2i relPoint2;
        Vector2i tile2;
        if (color.premultiplied) {
            throw new IllegalArgumentException("Color can not be premultiplied!");
        }
        Vector2i point = new Vector2i(px, pz);
        Vector3f colorV = new Vector3f(color.r, color.g, color.b);
        Vector2i tile = this.pointToTile(point);
        Vector2i relPoint = this.getPointRelativeToTile(tile, point);
        LowresModel model = this.getModel(tile);
        model.update(relPoint, height, colorV);
        if (relPoint.getX() == 0) {
            tile2 = tile.add(-1, 0);
            relPoint2 = this.getPointRelativeToTile(tile2, point);
            model2 = this.getModel(tile2);
            model2.update(relPoint2, height, colorV);
        }
        if (relPoint.getY() == 0) {
            tile2 = tile.add(0, -1);
            relPoint2 = this.getPointRelativeToTile(tile2, point);
            model2 = this.getModel(tile2);
            model2.update(relPoint2, height, colorV);
        }
        if (relPoint.getX() == 0 && relPoint.getY() == 0) {
            tile2 = tile.add(-1, -1);
            relPoint2 = this.getPointRelativeToTile(tile2, point);
            model2 = this.getModel(tile2);
            model2.update(relPoint2, height, colorV);
        }
    }

    public File getFile(Vector2i tile, boolean useGzip) {
        return FileUtils.coordsToFile(this.fileRoot, tile, "json" + (useGzip ? ".gz" : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LowresModel getModel(Vector2i tile) {
        File modelFile = this.getFile(tile, this.useGzip);
        CachedModel model = this.models.get(modelFile);
        if (model == null) {
            LowresModelManager lowresModelManager = this;
            synchronized (lowresModelManager) {
                model = this.models.get(modelFile);
                if (model == null) {
                    if (modelFile.exists()) {
                        try (FileInputStream fis = new FileInputStream(modelFile);){
                            InputStream is = fis;
                            if (this.useGzip) {
                                is = new GZIPInputStream(is);
                            }
                            String json = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                            model = new CachedModel(BufferGeometry.fromJson(json));
                        }
                        catch (IOException | IllegalArgumentException ex) {
                            Logger.global.logWarning("Failed to load lowres model '" + modelFile + "': " + ex);
                            try {
                                FileUtils.delete(modelFile);
                            }
                            catch (IOException ex2) {
                                Logger.global.logError("Failed to delete lowres-file: " + modelFile, ex2);
                            }
                        }
                    }
                    if (model == null) {
                        model = new CachedModel(this.pointsPerLowresTile);
                    }
                    this.models.put(modelFile, model);
                    this.tidyUpModelCache();
                }
            }
        }
        return model;
    }

    public synchronized void tidyUpModelCache() {
        ArrayList<Map.Entry<File, CachedModel>> entries = new ArrayList<Map.Entry<File, CachedModel>>(this.models.size());
        entries.addAll(this.models.entrySet());
        entries.sort((e1, e2) -> (int)Math.signum(((CachedModel)e1.getValue()).cacheTime - ((CachedModel)e2.getValue()).cacheTime));
        int size = entries.size();
        for (Map.Entry entry : entries) {
            if (size > 10) {
                this.saveAndRemoveModel((File)entry.getKey(), (CachedModel)entry.getValue());
                continue;
            }
            if (((CachedModel)entry.getValue()).getCacheTime() <= 120000L) continue;
            this.saveModel((File)entry.getKey(), (CachedModel)entry.getValue());
        }
    }

    private synchronized void saveAndRemoveModel(File modelFile, CachedModel model) {
        this.models.remove(modelFile);
        try {
            model.save(modelFile, false, this.useGzip);
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to save and unload lowres-model: " + modelFile, ex);
        }
    }

    private void saveModel(File modelFile, CachedModel model) {
        try {
            model.save(modelFile, false, this.useGzip);
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to save lowres-model: " + modelFile, ex);
        }
        model.resetCacheTime();
    }

    private Vector2i pointToTile(Vector2i point) {
        return new Vector2i(Math.floorDiv(point.getX(), this.pointsPerLowresTile.getX()), Math.floorDiv(point.getY(), this.pointsPerLowresTile.getY()));
    }

    private Vector2i getPointRelativeToTile(Vector2i tile, Vector2i point) {
        return new Vector2i(point.getX() - tile.getX() * this.pointsPerLowresTile.getX(), point.getY() - tile.getY() * this.pointsPerLowresTile.getY());
    }

    public Vector2i getTileSize() {
        return this.pointsPerLowresTile;
    }

    public Vector2i getPointsPerHiresTile() {
        return this.pointsPerHiresTile;
    }

    private static class CachedModel
    extends LowresModel {
        private long cacheTime = System.currentTimeMillis();

        public CachedModel(BufferGeometry model) {
            super(model);
        }

        public CachedModel(Vector2i gridSize) {
            super(gridSize);
        }

        public long getCacheTime() {
            return System.currentTimeMillis() - this.cacheTime;
        }

        public void resetCacheTime() {
            this.cacheTime = System.currentTimeMillis();
        }
    }
}

