/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.lowres;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3f;
import de.bluecolored.bluemap.core.threejs.BufferGeometry;
import de.bluecolored.bluemap.core.util.AtomicFileHelper;
import de.bluecolored.bluemap.core.util.MathUtils;
import de.bluecolored.bluemap.core.util.ModelUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;

public class LowresModel {
    private final BufferGeometry model;
    private Map<Vector2i, LowresPoint> changes;
    private boolean hasUnsavedChanges;
    private final Object fileLock = new Object();
    private final Object modelLock = new Object();

    public LowresModel(Vector2i gridSize) {
        this(ModelUtils.makeGrid(gridSize).toBufferGeometry());
    }

    public LowresModel(BufferGeometry model) {
        this.model = model;
        this.changes = new ConcurrentHashMap<Vector2i, LowresPoint>();
        this.hasUnsavedChanges = true;
    }

    public void update(Vector2i point, float height, Vector3f color) {
        this.changes.put(point, new LowresPoint(height, color));
        this.hasUnsavedChanges = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file, boolean force, boolean useGzip) throws IOException {
        String json;
        if (!force && !this.hasUnsavedChanges) {
            return;
        }
        this.hasUnsavedChanges = false;
        this.flush();
        Object object = this.modelLock;
        synchronized (object) {
            json = this.model.toJson();
        }
        object = this.fileLock;
        synchronized (object) {
            FilterOutputStream os = new BufferedOutputStream(AtomicFileHelper.createFilepartOutputStream(file));
            if (useGzip) {
                os = new GZIPOutputStream(os);
            }
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);
            try (PrintWriter pw = new PrintWriter(osw);){
                pw.print(json);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.changes.isEmpty()) {
            return;
        }
        Object object = this.modelLock;
        synchronized (object) {
            if (this.changes.isEmpty()) {
                return;
            }
            Map<Vector2i, LowresPoint> points = this.changes;
            this.changes = new ConcurrentHashMap<Vector2i, LowresPoint>();
            float[] position = this.model.attributes.get("position").values();
            float[] color = this.model.attributes.get("color").values();
            float[] normal = this.model.attributes.get("normal").values();
            int vertexCount = Math.floorDiv(position.length, 3);
            for (int i = 0; i < vertexCount; ++i) {
                int pz;
                int j = i * 3;
                int px = Math.round(position[j]);
                Vector2i p = new Vector2i(px, pz = Math.round(position[j + 2]));
                LowresPoint lrp = points.get(p);
                if (lrp == null) continue;
                position[j + 1] = lrp.height;
                color[j] = lrp.color.getX();
                color[j + 1] = lrp.color.getY();
                color[j + 2] = lrp.color.getZ();
                int f = Math.floorDiv(i, 3) * 3 * 3;
                Vector3f p1 = new Vector3f(position[f], position[f + 1], position[f + 2]);
                Vector3f p2 = new Vector3f(position[f + 3], position[f + 4], position[f + 5]);
                Vector3f p3 = new Vector3f(position[f + 6], position[f + 7], position[f + 8]);
                Vector3f n = MathUtils.getSurfaceNormal(p1, p2, p3);
                normal[f] = n.getX();
                normal[f + 1] = n.getY();
                normal[f + 2] = n.getZ();
                normal[f + 3] = n.getX();
                normal[f + 4] = n.getY();
                normal[f + 5] = n.getZ();
                normal[f + 6] = n.getX();
                normal[f + 7] = n.getY();
                normal[f + 8] = n.getZ();
            }
        }
    }

    public BufferGeometry getBufferGeometry() {
        this.flush();
        return this.model;
    }

    public static class LowresPoint {
        private final float height;
        private final Vector3f color;

        public LowresPoint(float height, Vector3f color) {
            this.height = height;
            this.color = color;
        }
    }
}

