/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires.blockmodel;

import de.bluecolored.bluemap.core.map.hires.BlockModelView;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.blockmodel.LiquidModelBuilder;
import de.bluecolored.bluemap.core.map.hires.blockmodel.ResourceModelBuilder;
import de.bluecolored.bluemap.core.resourcepack.NoSuchResourceException;
import de.bluecolored.bluemap.core.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resourcepack.blockmodel.TransformedBlockModelResource;
import de.bluecolored.bluemap.core.resourcepack.blockstate.BlockStateResource;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.BlockNeighborhood;
import de.bluecolored.bluemap.core.world.BlockState;
import java.util.ArrayList;
import java.util.Collection;

public class BlockStateModelFactory {
    private final ResourcePack resourcePack;
    private final ResourceModelBuilder resourceModelBuilder;
    private final LiquidModelBuilder liquidModelBuilder;
    private final Collection<TransformedBlockModelResource> bmrs;
    private static final BlockState WATERLOGGED_BLOCKSTATE = new BlockState("minecraft:water");

    public BlockStateModelFactory(ResourcePack resourcePack, RenderSettings renderSettings) {
        this.resourcePack = resourcePack;
        this.resourceModelBuilder = new ResourceModelBuilder(resourcePack, renderSettings);
        this.liquidModelBuilder = new LiquidModelBuilder(resourcePack, renderSettings);
        this.bmrs = new ArrayList<TransformedBlockModelResource>();
    }

    public void render(BlockNeighborhood<?> block, BlockModelView blockModel, Color blockColor) throws NoSuchResourceException {
        this.render(block, block.getBlockState(), blockModel, blockColor);
    }

    public void render(BlockNeighborhood<?> block, BlockState blockState, BlockModelView blockModel, Color blockColor) throws NoSuchResourceException {
        if (blockState.isAir()) {
            return;
        }
        int modelStart = blockModel.getStart();
        this.renderModel(block, blockState, blockModel.initialize(), blockColor);
        if (blockState.isWaterlogged() || block.getProperties().isAlwaysWaterlogged()) {
            this.renderModel(block, WATERLOGGED_BLOCKSTATE, blockModel.initialize(), blockColor);
        }
        blockModel.initialize(modelStart);
    }

    private void renderModel(BlockNeighborhood<?> block, BlockState blockState, BlockModelView blockModel, Color blockColor) throws NoSuchResourceException {
        int modelStart = blockModel.getStart();
        BlockStateResource resource = this.resourcePack.getBlockStateResource(blockState);
        block3: for (TransformedBlockModelResource bmr : resource.getModels(blockState, block.getX(), block.getY(), block.getZ(), this.bmrs)) {
            switch (bmr.getModel().getType()) {
                case LIQUID: {
                    this.liquidModelBuilder.build(block, blockState, bmr, blockModel.initialize(), blockColor);
                    continue block3;
                }
            }
            this.resourceModelBuilder.build(block, bmr, blockModel.initialize(), blockColor);
        }
        blockModel.initialize(modelStart);
    }
}

