/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import de.bluecolored.bluemap.core.util.math.Color;

public class HiresTileMeta {
    private final int[] heights;
    private final float[] colors;
    private final int minX;
    private final int minZ;
    private final int maxX;
    private final int maxZ;
    private final int sizeX;
    private final int sizeZ;

    public HiresTileMeta(int minX, int minZ, int maxX, int maxZ) {
        this.minX = minX;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxZ = maxZ;
        this.sizeX = maxX - minX + 1;
        this.sizeZ = maxZ - minZ + 1;
        this.heights = new int[this.sizeX * this.sizeZ];
        this.colors = new float[this.sizeX * this.sizeZ * 4];
    }

    public void setHeight(int x, int z, int height) {
        this.heights[(x - this.minX) * this.sizeZ + (z - this.minZ)] = height;
    }

    public int getHeight(int x, int z) {
        return this.heights[(x - this.minX) * this.sizeZ + (z - this.minZ)];
    }

    public void setColor(int x, int z, Color color) {
        if (!color.premultiplied) {
            throw new IllegalArgumentException("Color should be premultiplied!");
        }
        this.setColor(x, z, color.r, color.g, color.b, color.a);
    }

    private void setColor(int x, int z, float r, float g2, float b, float a) {
        int index = ((x - this.minX) * this.sizeZ + (z - this.minZ)) * 4;
        this.colors[index] = r;
        this.colors[index + 1] = g2;
        this.colors[index + 2] = b;
        this.colors[index + 3] = a;
    }

    public Color getColor(int x, int z, Color target) {
        int index = ((x - this.minX) * this.sizeZ + (z - this.minZ)) * 4;
        return target.set(this.colors[index], this.colors[index + 1], this.colors[index + 2], this.colors[index + 3], true);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }
}

