/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.map.hires.BlockModelView;
import de.bluecolored.bluemap.core.map.hires.HiresTileMeta;
import de.bluecolored.bluemap.core.map.hires.HiresTileModel;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.blockmodel.BlockStateModelFactory;
import de.bluecolored.bluemap.core.resourcepack.NoSuchResourceException;
import de.bluecolored.bluemap.core.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.BlockNeighborhood;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.World;

public class HiresModelRenderer {
    private final ResourcePack resourcePack;
    private final RenderSettings renderSettings;

    public HiresModelRenderer(ResourcePack resourcePack, RenderSettings renderSettings) {
        this.renderSettings = renderSettings;
        this.resourcePack = resourcePack;
    }

    public HiresTileMeta render(World world, Vector3i modelMin, Vector3i modelMax, HiresTileModel model) {
        Vector3i min2 = modelMin.max(this.renderSettings.getMin());
        Vector3i max = modelMax.min(this.renderSettings.getMax());
        Vector3i modelAnchor = new Vector3i(modelMin.getX(), 0, modelMin.getZ());
        HiresTileMeta tileMeta = new HiresTileMeta(modelMin.getX(), modelMin.getZ(), modelMax.getX(), modelMax.getZ());
        BlockStateModelFactory modelFactory = new BlockStateModelFactory(this.resourcePack, this.renderSettings);
        Color columnColor = new Color();
        Color blockColor = new Color();
        BlockNeighborhood block = new BlockNeighborhood(this.resourcePack, this.renderSettings, world, 0, 0, 0);
        BlockModelView blockModel = new BlockModelView(model);
        for (int x = min2.getX(); x <= max.getX(); ++x) {
            for (int z = min2.getZ(); z <= max.getZ(); ++z) {
                int maxHeight = 0;
                columnColor.set(0.0f, 0.0f, 0.0f, 1.0f, true);
                if (this.renderSettings.isInsideRenderBoundaries(x, z)) {
                    int minY = Math.max(min2.getY(), world.getMinY(x, z));
                    int maxY = Math.min(max.getY(), world.getMaxY(x, z));
                    for (int y = minY; y <= maxY; ++y) {
                        block.set(x, y, z);
                        if (!block.isInsideRenderBounds()) continue;
                        blockColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
                        blockModel.initialize();
                        try {
                            modelFactory.render(block, blockModel, blockColor);
                        }
                        catch (NoSuchResourceException e) {
                            try {
                                modelFactory.render(block, BlockState.MISSING, blockModel.reset(), blockColor);
                            }
                            catch (NoSuchResourceException e2) {
                                e.addSuppressed(e2);
                            }
                        }
                        if (blockModel.getSize() <= 0) continue;
                        blockModel.translate(x - modelAnchor.getX(), y - modelAnchor.getY(), z - modelAnchor.getZ());
                        if (!(blockColor.a > 0.0f)) continue;
                        maxHeight = y;
                        columnColor.overlay(blockColor);
                    }
                }
                tileMeta.setHeight(x, z, maxHeight);
                tileMeta.setColor(x, z, columnColor);
            }
        }
        return tileMeta;
    }
}

