/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.hires.HiresModelRenderer;
import de.bluecolored.bluemap.core.map.hires.HiresTileMeta;
import de.bluecolored.bluemap.core.map.hires.HiresTileModel;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.util.AtomicFileHelper;
import de.bluecolored.bluemap.core.util.FileUtils;
import de.bluecolored.bluemap.core.world.Grid;
import de.bluecolored.bluemap.core.world.World;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;

public class HiresModelManager {
    private final Path fileRoot;
    private final HiresModelRenderer renderer;
    private final Grid tileGrid;
    private final boolean useGzip;

    public HiresModelManager(Path fileRoot, ResourcePack resourcePack, RenderSettings renderSettings, Grid tileGrid) {
        this(fileRoot, new HiresModelRenderer(resourcePack, renderSettings), tileGrid, renderSettings.useGzipCompression());
    }

    public HiresModelManager(Path fileRoot, HiresModelRenderer renderer, Grid tileGrid, boolean useGzip) {
        this.fileRoot = fileRoot;
        this.renderer = renderer;
        this.tileGrid = tileGrid;
        this.useGzip = useGzip;
    }

    public HiresTileMeta render(World world, Vector2i tile) {
        Vector2i tileMin = this.tileGrid.getCellMin(tile);
        Vector2i tileMax = this.tileGrid.getCellMax(tile);
        Vector3i modelMin = new Vector3i(tileMin.getX(), Integer.MIN_VALUE, tileMin.getY());
        Vector3i modelMax = new Vector3i(tileMax.getX(), Integer.MAX_VALUE, tileMax.getY());
        HiresTileModel model = HiresTileModel.claimInstance();
        HiresTileMeta tileMeta = this.renderer.render(world, modelMin, modelMax, model);
        this.save(model, tile);
        HiresTileModel.recycleInstance(model);
        return tileMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(HiresTileModel model, Vector2i tile) {
        File file = this.getFile(tile, this.useGzip);
        OutputStream os = null;
        try {
            os = AtomicFileHelper.createFilepartOutputStream(file);
            os = new BufferedOutputStream(os);
            if (this.useGzip) {
                os = new GZIPOutputStream(os);
            }
            model.writeBufferGeometryJson(os);
        }
        catch (IOException e) {
            Logger.global.logError("Failed to save hires model: " + file, e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                Logger.global.logError("Failed to close file: " + file, e);
            }
        }
    }

    public Grid getTileGrid() {
        return this.tileGrid;
    }

    public File getFile(Vector2i tilePos, boolean gzip) {
        return FileUtils.coordsToFile(this.fileRoot, tilePos, "json" + (gzip ? ".gz" : ""));
    }
}

