/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.bluemap.core.util.AtomicFileHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

@DebugDump
public class MapRenderState {
    private final Map<Vector2i, Long> regionRenderTimes = new HashMap<Vector2i, Long>();

    public synchronized void setRenderTime(Vector2i regionPos, long renderTime) {
        this.regionRenderTimes.put(regionPos, renderTime);
    }

    public synchronized long getRenderTime(Vector2i regionPos) {
        Long renderTime = this.regionRenderTimes.get(regionPos);
        if (renderTime == null) {
            return -1L;
        }
        return renderTime;
    }

    public synchronized void reset() {
        this.regionRenderTimes.clear();
    }

    public synchronized void save(File file) throws IOException {
        OutputStream fOut = AtomicFileHelper.createFilepartOutputStream(file);
        GZIPOutputStream gOut = new GZIPOutputStream(fOut);
        try (DataOutputStream dOut = new DataOutputStream(gOut);){
            dOut.writeInt(this.regionRenderTimes.size());
            for (Map.Entry<Vector2i, Long> entry : this.regionRenderTimes.entrySet()) {
                Vector2i regionPos = entry.getKey();
                long renderTime = entry.getValue();
                dOut.writeInt(regionPos.getX());
                dOut.writeInt(regionPos.getY());
                dOut.writeLong(renderTime);
            }
            dOut.flush();
        }
    }

    public synchronized void load(File file) throws IOException {
        this.regionRenderTimes.clear();
        try (FileInputStream fIn = new FileInputStream(file);
             GZIPInputStream gIn = new GZIPInputStream(fIn);
             DataInputStream dIn = new DataInputStream(gIn);){
            int size = dIn.readInt();
            for (int i = 0; i < size; ++i) {
                Vector2i regionPos = new Vector2i(dIn.readInt(), dIn.readInt());
                long renderTime = dIn.readLong();
                this.regionRenderTimes.put(regionPos, renderTime);
            }
        }
    }
}

