/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.MapRenderState;
import de.bluecolored.bluemap.core.map.MapSettings;
import de.bluecolored.bluemap.core.map.hires.HiresModelManager;
import de.bluecolored.bluemap.core.map.hires.HiresTileMeta;
import de.bluecolored.bluemap.core.map.lowres.LowresModelManager;
import de.bluecolored.bluemap.core.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.world.Grid;
import de.bluecolored.bluemap.core.world.World;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Predicate;

@DebugDump
public class BmMap {
    private final String id;
    private final String name;
    private final World world;
    private final Path fileRoot;
    private final MapRenderState renderState;
    private final HiresModelManager hiresModelManager;
    private final LowresModelManager lowresModelManager;
    private Predicate<Vector2i> tileFilter;
    private long renderTimeSumNanos;
    private long tilesRendered;

    public BmMap(String id, String name, World world, Path fileRoot, ResourcePack resourcePack, MapSettings settings) throws IOException {
        this.id = Objects.requireNonNull(id);
        this.name = Objects.requireNonNull(name);
        this.world = Objects.requireNonNull(world);
        this.fileRoot = Objects.requireNonNull(fileRoot);
        Objects.requireNonNull(resourcePack);
        Objects.requireNonNull(settings);
        this.renderState = new MapRenderState();
        File rstateFile = this.getRenderStateFile();
        if (rstateFile.exists()) {
            try {
                this.renderState.load(rstateFile);
            }
            catch (IOException ex) {
                Logger.global.logWarning("Failed to load render-state for map '" + this.getId() + "': " + ex);
            }
        }
        this.hiresModelManager = new HiresModelManager(fileRoot.resolve("hires"), resourcePack, settings, new Grid(settings.getHiresTileSize(), 2));
        this.lowresModelManager = new LowresModelManager(fileRoot.resolve("lowres"), new Vector2i(settings.getLowresPointsPerLowresTile(), settings.getLowresPointsPerLowresTile()), new Vector2i(settings.getLowresPointsPerHiresTile(), settings.getLowresPointsPerHiresTile()), settings.useGzipCompression());
        this.tileFilter = t -> true;
        this.renderTimeSumNanos = 0L;
        this.tilesRendered = 0L;
    }

    public void renderTile(Vector2i tile) {
        if (!this.tileFilter.test(tile)) {
            return;
        }
        long start = System.nanoTime();
        HiresTileMeta tileMeta = this.hiresModelManager.render(this.world, tile);
        this.lowresModelManager.render(tileMeta);
        long end = System.nanoTime();
        long delta = end - start;
        this.renderTimeSumNanos += delta;
        ++this.tilesRendered;
    }

    public synchronized void save() {
        this.lowresModelManager.save();
        try {
            this.renderState.save(this.getRenderStateFile());
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to save render-state for map: '" + this.id + "'!", ex);
        }
    }

    public File getRenderStateFile() {
        return this.fileRoot.resolve(".rstate").toFile();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public World getWorld() {
        return this.world;
    }

    public Path getFileRoot() {
        return this.fileRoot;
    }

    public MapRenderState getRenderState() {
        return this.renderState;
    }

    public HiresModelManager getHiresModelManager() {
        return this.hiresModelManager;
    }

    public LowresModelManager getLowresModelManager() {
        return this.lowresModelManager;
    }

    public Predicate<Vector2i> getTileFilter() {
        return this.tileFilter;
    }

    public void setTileFilter(Predicate<Vector2i> tileFilter) {
        this.tileFilter = tileFilter;
    }

    public long getAverageNanosPerTile() {
        return this.renderTimeSumNanos / this.tilesRendered;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BmMap) {
            BmMap that = (BmMap)obj;
            return this.id.equals(that.id);
        }
        return false;
    }

    public String toString() {
        return "BmMap{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", world=" + this.world + ", fileRoot=" + this.fileRoot + '}';
    }
}

