/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.logger;

import de.bluecolored.bluemap.core.logger.AbstractLogger;
import java.io.PrintStream;

public class PrintStreamLogger
extends AbstractLogger {
    private PrintStream out;
    private PrintStream err;
    boolean isDebug;

    public PrintStreamLogger(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
        this.isDebug = true;
    }

    public PrintStreamLogger(PrintStream out, PrintStream err, boolean debug) {
        this.out = out;
        this.err = err;
        this.isDebug = debug;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean debug) {
        this.isDebug = debug;
    }

    @Override
    public void logError(String message, Throwable throwable) {
        this.err.println("[ERROR] " + message);
        throwable.printStackTrace(this.err);
    }

    @Override
    public void logWarning(String message) {
        this.out.println("[WARNING] " + message);
    }

    @Override
    public void logInfo(String message) {
        this.out.println("[INFO] " + message);
    }

    @Override
    public void logDebug(String message) {
        if (this.isDebug) {
            this.out.println("[DEBUG] " + message);
        }
    }

    @Override
    public void noFloodDebug(String key, String message) {
        if (this.isDebug) {
            super.noFloodDebug(key, message);
        }
    }

    @Override
    public void noFloodDebug(String message) {
        if (this.isDebug) {
            super.noFloodDebug(message);
        }
    }
}

