/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.logger;

import de.bluecolored.bluemap.core.logger.AbstractLogger;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class LoggerLogger
extends AbstractLogger {
    private static LoggerLogger instance = null;
    private java.util.logging.Logger logger = java.util.logging.Logger.getLogger("bluemap");
    private SimpleFormatter formatter;

    private LoggerLogger() {
        this.logger.setUseParentHandlers(false);
        ConsoleHandler cHandler = new ConsoleHandler();
        this.formatter = new SimpleFormatter(){

            @Override
            public synchronized String format(LogRecord record) {
                String stackTrace = record.getThrown() == null ? "" : ExceptionUtils.getStackTrace((Throwable)record.getThrown());
                return String.format("[%1$s] %2$s%3$s%n", record.getLevel(), record.getMessage(), stackTrace);
            }
        };
        cHandler.setFormatter(this.formatter);
        this.logger.addHandler(cHandler);
    }

    public static LoggerLogger getInstance() {
        if (instance == null) {
            instance = new LoggerLogger();
        }
        return instance;
    }

    public void addFileHandler(String filename, boolean append) {
        try {
            File file = new File(filename);
            FileUtils.mkDirsParent(file);
            FileHandler fHandler = new FileHandler(filename, append);
            fHandler.setFormatter(this.formatter);
            this.logger.addHandler(fHandler);
        }
        catch (IOException e) {
            Logger.global.logError("Error while opening log file!", e);
        }
    }

    @Override
    public void logError(String message, Throwable throwable) {
        this.logger.log(Level.SEVERE, message, throwable);
    }

    @Override
    public void logWarning(String message) {
        this.logger.log(Level.WARNING, message);
    }

    @Override
    public void logInfo(String message) {
        this.logger.log(Level.INFO, message);
    }

    @Override
    public void logDebug(String message) {
        this.logger.log(Level.FINE, message);
    }
}

