/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.config;

import de.bluecolored.bluemap.core.config.ConfigManager;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

@DebugDump
public class WebServerConfig {
    private boolean enabled = true;
    private File webRoot = new File("web");
    private InetAddress bindAddress = null;
    private int port = 8100;
    private int maxConnections = 100;

    public WebServerConfig(ConfigurationNode node) throws IOException {
        this.enabled = node.node("enabled").getBoolean(false);
        if (this.enabled) {
            String webRootString = node.node("webroot").getString();
            if (webRootString == null) {
                throw new IOException("Invalid configuration: Node webroot is not defined");
            }
            this.webRoot = ConfigManager.toFolder(webRootString);
            String bindAddressString = node.node("ip").getString("");
            this.bindAddress = bindAddressString.isEmpty() || bindAddressString.equals("0.0.0.0") || bindAddressString.equals("::0") ? new InetSocketAddress(0).getAddress() : (bindAddressString.equals("#getLocalHost") ? InetAddress.getLocalHost() : InetAddress.getByName(bindAddressString));
            this.port = node.node("port").getInt(8100);
            this.maxConnections = node.node("maxConnectionCount").getInt(100);
        }
    }

    public boolean isWebserverEnabled() {
        return this.enabled;
    }

    public File getWebRoot() {
        return this.webRoot;
    }

    public InetAddress getWebserverBindAddress() {
        return this.bindAddress;
    }

    public int getWebserverPort() {
        return this.port;
    }

    public int getWebserverMaxConnections() {
        return this.maxConnections;
    }
}

