/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.config;

import de.bluecolored.bluemap.core.config.ConfigManager;
import de.bluecolored.bluemap.core.config.MapConfig;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@DebugDump
public class RenderConfig {
    private File webRoot = new File("web");
    private boolean useCookies;
    private boolean enableFreeFlight;
    private List<MapConfig> mapConfigs = new ArrayList<MapConfig>();

    public RenderConfig(ConfigurationNode node) throws IOException {
        String webRootString = node.node("webroot").getString();
        if (webRootString == null) {
            throw new IOException("Invalid configuration: Node webroot is not defined");
        }
        this.webRoot = ConfigManager.toFolder(webRootString);
        this.useCookies = node.node("useCookies").getBoolean(true);
        this.enableFreeFlight = node.node("enableFreeFlight").getBoolean(true);
        this.mapConfigs = new ArrayList<MapConfig>();
        for (ConfigurationNode configurationNode : node.node("maps").childrenList()) {
            this.mapConfigs.add(new MapConfig(configurationNode));
        }
    }

    public File getWebRoot() {
        return this.webRoot;
    }

    public boolean isUseCookies() {
        return this.useCookies;
    }

    public boolean isEnableFreeFlight() {
        return this.enableFreeFlight;
    }

    public List<MapConfig> getMapConfigs() {
        return this.mapConfigs;
    }
}

