/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.config;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.bluemap.core.map.MapSettings;
import de.bluecolored.bluemap.core.util.ConfigUtils;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import java.io.IOException;
import java.util.regex.Pattern;

@DebugDump
public class MapConfig
implements MapSettings {
    private static final Pattern VALID_ID_PATTERN = Pattern.compile("[a-zA-Z0-9_]+");
    private String id;
    private String name;
    private String world;
    private Vector2i startPos;
    private int skyColor;
    private float ambientLight;
    private int worldSkyLight;
    private int removeCavesBelowY;
    private boolean caveDetectionUsesBlockLight;
    private Vector3i min;
    private Vector3i max;
    private boolean renderEdges;
    private boolean useGzip;
    private boolean ignoreMissingLightData;
    private int hiresTileSize;
    private int lowresPointsPerHiresTile;
    private int lowresPointsPerLowresTile;

    public MapConfig(ConfigurationNode node) throws IOException {
        this.id = node.node("id").getString("");
        if (this.id.isEmpty()) {
            throw new IOException("Invalid configuration: Node maps[?].id is not defined");
        }
        if (!VALID_ID_PATTERN.matcher(this.id).matches()) {
            throw new IOException("Invalid configuration: Node maps[?].id '" + this.id + "' has invalid characters in it");
        }
        this.name = node.node("name").getString(this.id);
        this.world = node.node("world").getString("");
        if (this.world.isEmpty()) {
            throw new IOException("Invalid configuration: Node maps[?].world is not defined");
        }
        if (!node.node("startPos").virtual()) {
            this.startPos = ConfigUtils.readVector2i(node.node("startPos"));
        }
        this.skyColor = !node.node("skyColor").virtual() ? ConfigUtils.readColorInt(node.node("skyColor")) : 8236031;
        this.ambientLight = node.node("ambientLight").getFloat(0.0f);
        this.worldSkyLight = node.node("worldSkyLight").getInt(15);
        this.removeCavesBelowY = node.node("removeCavesBelowY").getInt(55);
        this.caveDetectionUsesBlockLight = node.node("caveDetectionUsesBlockLight").getBoolean(false);
        int minX = node.node("minX").getInt(MapSettings.super.getMin().getX());
        int maxX = node.node("maxX").getInt(MapSettings.super.getMax().getX());
        int minZ = node.node("minZ").getInt(MapSettings.super.getMin().getZ());
        int maxZ = node.node("maxZ").getInt(MapSettings.super.getMax().getZ());
        int minY = node.node("minY").getInt(MapSettings.super.getMin().getY());
        int maxY = node.node("maxY").getInt(MapSettings.super.getMax().getY());
        this.min = new Vector3i(minX, minY, minZ);
        this.max = new Vector3i(maxX, maxY, maxZ);
        this.renderEdges = node.node("renderEdges").getBoolean(true);
        this.useGzip = node.node("useCompression").getBoolean(true);
        this.ignoreMissingLightData = node.node("ignoreMissingLightData").getBoolean(false);
        this.hiresTileSize = node.node("hires", "tileSize").getInt(32);
        this.lowresPointsPerHiresTile = node.node("lowres", "pointsPerHiresTile").getInt(4);
        this.lowresPointsPerLowresTile = node.node("lowres", "pointsPerLowresTile").getInt(50);
        double blocksPerPoint = (double)this.hiresTileSize / (double)this.lowresPointsPerHiresTile;
        if (blocksPerPoint != Math.floor(blocksPerPoint)) {
            throw new IOException("Invalid configuration: Invalid map resolution settings of map " + this.id + ": hires.tileSize / lowres.pointsPerTile has to be an integer result");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getWorldPath() {
        return this.world;
    }

    public Vector2i getStartPos() {
        return this.startPos;
    }

    public int getSkyColor() {
        return this.skyColor;
    }

    @Override
    public float getAmbientLight() {
        return this.ambientLight;
    }

    @Override
    public int getWorldSkyLight() {
        return this.worldSkyLight;
    }

    @Override
    public int getRemoveCavesBelowY() {
        return this.removeCavesBelowY;
    }

    @Override
    public boolean isCaveDetectionUsesBlockLight() {
        return this.caveDetectionUsesBlockLight;
    }

    public boolean isIgnoreMissingLightData() {
        return this.ignoreMissingLightData;
    }

    @Override
    public int getHiresTileSize() {
        return this.hiresTileSize;
    }

    @Override
    public int getLowresPointsPerHiresTile() {
        return this.lowresPointsPerHiresTile;
    }

    @Override
    public int getLowresPointsPerLowresTile() {
        return this.lowresPointsPerLowresTile;
    }

    @Override
    public Vector3i getMin() {
        return this.min;
    }

    @Override
    public Vector3i getMax() {
        return this.max;
    }

    @Override
    public boolean isRenderEdges() {
        return this.renderEdges;
    }

    @Override
    public boolean useGzipCompression() {
        return this.useGzip;
    }
}

