/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.config;

import de.bluecolored.bluemap.core.config.ConfigManager;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import java.io.File;
import java.io.IOException;

@DebugDump
public class CoreConfig {
    private boolean downloadAccepted = false;
    private int renderThreadCount = 0;
    private boolean metricsEnabled = false;
    private File dataFolder = new File("data");

    public CoreConfig(ConfigurationNode node) throws IOException {
        this.downloadAccepted = node.node("accept-download").getBoolean(false);
        int processors = Runtime.getRuntime().availableProcessors();
        this.renderThreadCount = node.node("renderThreadCount").getInt(0);
        if (this.renderThreadCount <= 0) {
            this.renderThreadCount = processors + this.renderThreadCount;
        }
        if (this.renderThreadCount <= 0) {
            this.renderThreadCount = 1;
        }
        this.metricsEnabled = node.node("metrics").getBoolean(false);
        this.dataFolder = ConfigManager.toFolder(node.node("data").getString("data"));
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public boolean isDownloadAccepted() {
        return this.downloadAccepted;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public int getRenderThreadCount() {
        return this.renderThreadCount;
    }
}

