/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.config;

import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.config.Placeholder;
import de.bluecolored.bluemap.core.util.FileUtils;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import de.bluecolored.shadow.configurate.hocon.HoconConfigurationLoader;
import de.bluecolored.shadow.configurate.loader.ConfigurationLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ConfigManager {
    private static final Set<Placeholder> CONFIG_PLACEHOLDERS = new HashSet<Placeholder>();

    public ConfigurationNode loadOrCreate(File configFile, URL defaultConfig, URL defaultValues, boolean usePlaceholders, boolean generateEmptyConfig) throws IOException {
        ConfigurationNode configNode;
        if (!configFile.exists()) {
            FileUtils.mkDirsParent(configFile);
            if (defaultConfig != null) {
                String content;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(defaultConfig.openStream(), StandardCharsets.UTF_8));){
                    content = reader.lines().collect(Collectors.joining("\n"));
                }
                if (usePlaceholders) {
                    for (Placeholder placeholder : CONFIG_PLACEHOLDERS) {
                        content = placeholder.apply(content);
                    }
                }
                Files.write(configFile.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                configNode = this.getLoader(configFile).load();
            } else {
                ConfigurationLoader<? extends ConfigurationNode> loader = this.getLoader(configFile);
                configNode = loader.createNode();
                if (generateEmptyConfig) {
                    loader.save(configNode);
                }
            }
        } else {
            configNode = this.getLoader(configFile).load();
        }
        if (defaultValues != null) {
            ConfigurationNode defaultValuesNode = this.getLoader(defaultValues).load();
            configNode.mergeFrom(defaultValuesNode);
        }
        return configNode;
    }

    private ConfigurationLoader<? extends ConfigurationNode> getLoader(URL url) {
        if (url.getFile().endsWith(".json")) {
            return ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().url(url)).build();
        }
        return ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().url(url)).build();
    }

    private ConfigurationLoader<? extends ConfigurationNode> getLoader(File file) {
        if (file.getName().endsWith(".json")) {
            return ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().file(file)).build();
        }
        return ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().file(file)).build();
    }

    public static File toFolder(String pathString) throws IOException {
        Objects.requireNonNull(pathString);
        File file = new File(pathString);
        if (file.exists() && !file.isDirectory()) {
            throw new IOException("Invalid configuration: Path '" + file.getAbsolutePath() + "' is a file (should be a directory)");
        }
        return file;
    }

    static {
        CONFIG_PLACEHOLDERS.add(new Placeholder("version", BlueMap.VERSION));
        CONFIG_PLACEHOLDERS.add(new Placeholder("datetime-iso", () -> LocalDateTime.now().withNano(0).toString()));
    }
}

