/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3f;
import de.bluecolored.bluemap.core.config.MapConfig;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.util.FileUtils;
import de.bluecolored.bluemap.core.util.MathUtils;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import de.bluecolored.shadow.configurate.loader.ConfigurationLoader;
import de.bluecolored.shadow.configurate.serialize.SerializationException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;

public class WebSettings {
    private final ConfigurationLoader<? extends ConfigurationNode> configLoader;
    private ConfigurationNode rootNode;

    public WebSettings(File settingsFile) throws IOException {
        FileUtils.createFile(settingsFile);
        this.configLoader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().file(settingsFile)).build();
        this.load();
    }

    public void load() throws IOException {
        this.rootNode = this.configLoader.load();
    }

    public void save() throws IOException {
        this.configLoader.save(this.rootNode);
    }

    public void set(Object value, Object ... path) throws SerializationException {
        this.rootNode.node(path).set(value);
    }

    public Object get(Object ... path) {
        return this.rootNode.node(path).raw();
    }

    public String getString(Object ... path) {
        return this.rootNode.node(path).getString();
    }

    public int getInt(Object ... path) {
        return this.rootNode.node(path).getInt();
    }

    public long getLong(Object ... path) {
        return this.rootNode.node(path).getLong();
    }

    public float getFloat(Object ... path) {
        return this.rootNode.node(path).getFloat();
    }

    public double getDouble(Object ... path) {
        return this.rootNode.node(path).getDouble();
    }

    public Collection<String> getMapIds() {
        return this.rootNode.node("maps").childrenMap().keySet().stream().map(Object::toString).collect(Collectors.toSet());
    }

    public void setAllMapsEnabled(boolean enabled) throws SerializationException {
        for (ConfigurationNode configurationNode : this.rootNode.node("maps").childrenMap().values()) {
            configurationNode.node("enabled").set(enabled);
        }
    }

    public void setMapEnabled(boolean enabled, String mapId) throws SerializationException {
        this.set(enabled, "maps", mapId, "enabled");
    }

    public void setFrom(BmMap map) throws SerializationException {
        Vector2i hiresTileSize = map.getHiresModelManager().getTileGrid().getGridSize();
        Vector2i gridOrigin = map.getHiresModelManager().getTileGrid().getOffset();
        Vector2i lowresTileSize = map.getLowresModelManager().getTileSize();
        Vector2i lowresPointsPerHiresTile = map.getLowresModelManager().getPointsPerHiresTile();
        this.set(hiresTileSize.getX(), "maps", map.getId(), "hires", "tileSize", "x");
        this.set(hiresTileSize.getY(), "maps", map.getId(), "hires", "tileSize", "z");
        this.set(1, "maps", map.getId(), "hires", "scale", "x");
        this.set(1, "maps", map.getId(), "hires", "scale", "z");
        this.set(gridOrigin.getX(), "maps", map.getId(), "hires", "translate", "x");
        this.set(gridOrigin.getY(), "maps", map.getId(), "hires", "translate", "z");
        Vector2i pointSize = hiresTileSize.div(lowresPointsPerHiresTile);
        Vector2i tileSize = pointSize.mul(lowresTileSize);
        this.set(tileSize.getX(), "maps", map.getId(), "lowres", "tileSize", "x");
        this.set(tileSize.getY(), "maps", map.getId(), "lowres", "tileSize", "z");
        this.set(pointSize.getX(), "maps", map.getId(), "lowres", "scale", "x");
        this.set(pointSize.getY(), "maps", map.getId(), "lowres", "scale", "z");
        this.set(pointSize.getX() / 2, "maps", map.getId(), "lowres", "translate", "x");
        this.set(pointSize.getY() / 2, "maps", map.getId(), "lowres", "translate", "z");
        this.set(map.getWorld().getSpawnPoint().getX(), "maps", map.getId(), "startPos", "x");
        this.set(map.getWorld().getSpawnPoint().getZ(), "maps", map.getId(), "startPos", "z");
        this.set(map.getWorld().getUUID().toString(), "maps", map.getId(), "world");
    }

    public void setFrom(MapConfig mapConfig) throws SerializationException {
        Vector2i startPos = mapConfig.getStartPos();
        if (startPos != null) {
            this.set(startPos.getX(), "maps", mapConfig.getId(), "startPos", "x");
            this.set(startPos.getY(), "maps", mapConfig.getId(), "startPos", "z");
        }
        Vector3f skyColor = MathUtils.color3FromInt(mapConfig.getSkyColor());
        this.set(Float.valueOf(skyColor.getX()), "maps", mapConfig.getId(), "skyColor", "r");
        this.set(Float.valueOf(skyColor.getY()), "maps", mapConfig.getId(), "skyColor", "g");
        this.set(Float.valueOf(skyColor.getZ()), "maps", mapConfig.getId(), "skyColor", "b");
        this.set(Float.valueOf(mapConfig.getAmbientLight()), "maps", mapConfig.getId(), "ambientLight");
        this.setName(mapConfig.getName(), mapConfig.getId());
    }

    public void setOrdinal(int ordinal, String mapId) throws SerializationException {
        this.set(ordinal, "maps", mapId, "ordinal");
    }

    public int getOrdinal(String mapId) {
        return this.getInt("maps", mapId, "ordinal");
    }

    public void setName(String name, String mapId) throws SerializationException {
        this.set(name, "maps", mapId, "name");
    }

    public String getName(String mapId) {
        return this.getString("maps", mapId, "name");
    }
}

