/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import de.bluecolored.bluemap.core.webserver.HttpRequest;
import de.bluecolored.bluemap.core.webserver.HttpRequestHandler;
import de.bluecolored.bluemap.core.webserver.HttpResponse;
import de.bluecolored.bluemap.core.webserver.HttpStatusCode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class FileRequestHandler
implements HttpRequestHandler {
    private static final long DEFLATE_MIN_SIZE = 10240L;
    private static final long DEFLATE_MAX_SIZE = 0xA00000L;
    private static final long INFLATE_MAX_SIZE = 0xA00000L;
    private final Path webRoot;
    private final String serverName;
    private final File emptyTileFile;

    public FileRequestHandler(Path webRoot, String serverName) {
        this.webRoot = webRoot.normalize();
        this.serverName = serverName;
        this.emptyTileFile = webRoot.resolve("assets").resolve("emptyTile.json").toFile();
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        if (!request.getMethod().equalsIgnoreCase("GET") && !request.getMethod().equalsIgnoreCase("POST")) {
            return new HttpResponse(HttpStatusCode.NOT_IMPLEMENTED);
        }
        HttpResponse response = this.generateResponse(request);
        response.addHeader("Server", this.serverName);
        HttpStatusCode status = response.getStatusCode();
        if (status.getCode() >= 400) {
            response.setData(status.getCode() + " - " + status.getMessage() + "\n" + this.serverName);
        }
        return response;
    }

    private HttpResponse generateResponse(HttpRequest request) {
        int pointIndex;
        File deflatedFile;
        String path = request.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Path filePath = this.webRoot;
        try {
            filePath = this.webRoot.resolve(path);
        }
        catch (InvalidPathException e) {
            return new HttpResponse(HttpStatusCode.NOT_FOUND);
        }
        boolean isDeflationPossible = request.getLowercaseHeader("Accept-Encoding").contains("gzip");
        boolean isDeflated = false;
        if (!filePath.normalize().startsWith(this.webRoot)) {
            return new HttpResponse(HttpStatusCode.FORBIDDEN);
        }
        File file = filePath.toFile();
        if (file.isDirectory() && !request.getPath().endsWith("/")) {
            HttpResponse response = new HttpResponse(HttpStatusCode.SEE_OTHER);
            response.addHeader("Location", "/" + path + "/" + (request.getGETParamString().isEmpty() ? "" : "?" + request.getGETParamString()));
            return response;
        }
        if (!file.exists() || file.isDirectory()) {
            file = new File(filePath.toString() + ".gz");
            isDeflated = true;
        }
        if (!file.exists() || file.isDirectory()) {
            file = new File(filePath.toString() + "/index.html");
            isDeflated = false;
        }
        if (!file.exists() || file.isDirectory()) {
            file = new File(filePath.toString() + "/index.html.gz");
            isDeflated = true;
        }
        if (!file.exists() && file.toPath().startsWith(this.webRoot.resolve("data"))) {
            file = this.emptyTileFile;
            isDeflated = false;
        }
        if (!file.exists() || file.isDirectory()) {
            return new HttpResponse(HttpStatusCode.NOT_FOUND);
        }
        if (isDeflationPossible && !file.getName().endsWith(".gz") && (deflatedFile = new File(file.getAbsolutePath() + ".gz")).exists()) {
            file = deflatedFile;
            isDeflated = true;
        }
        if (!file.toPath().normalize().startsWith(this.webRoot) || file.isDirectory()) {
            return new HttpResponse(HttpStatusCode.FORBIDDEN);
        }
        long lastModified = file.lastModified();
        Set<String> modStringSet = request.getHeader("If-Modified-Since");
        if (!modStringSet.isEmpty()) {
            try {
                long since = FileRequestHandler.stringToTimestamp(modStringSet.iterator().next());
                if (since + 1000L >= lastModified) {
                    return new HttpResponse(HttpStatusCode.NOT_MODIFIED);
                }
            }
            catch (IllegalArgumentException since) {
                // empty catch block
            }
        }
        String eTag = Long.toHexString(file.length()) + Integer.toHexString(file.hashCode()) + Long.toHexString(lastModified);
        Set<String> etagStringSet = request.getHeader("If-None-Match");
        if (!etagStringSet.isEmpty() && etagStringSet.iterator().next().equals(eTag)) {
            return new HttpResponse(HttpStatusCode.NOT_MODIFIED);
        }
        HttpResponse response = new HttpResponse(HttpStatusCode.OK);
        response.addHeader("ETag", eTag);
        if (lastModified > 0L) {
            response.addHeader("Last-Modified", FileRequestHandler.timestampToString(lastModified));
        }
        response.addHeader("Cache-Control", "public");
        response.addHeader("Cache-Control", "max-age=" + TimeUnit.HOURS.toSeconds(1L));
        String filetype = file.getName();
        if (filetype.endsWith(".gz")) {
            filetype = filetype.substring(0, filetype.length() - 3);
        }
        if ((pointIndex = filetype.lastIndexOf(46)) >= 0) {
            filetype = filetype.substring(pointIndex + 1);
        }
        String contentType = "text/plain";
        switch (filetype) {
            case "json": {
                contentType = "application/json";
                break;
            }
            case "png": {
                contentType = "image/png";
                break;
            }
            case "jpg": 
            case "jpeg": 
            case "jpe": {
                contentType = "image/jpeg";
                break;
            }
            case "svg": {
                contentType = "image/svg+xml";
                break;
            }
            case "css": {
                contentType = "text/css";
                break;
            }
            case "js": {
                contentType = "text/javascript";
                break;
            }
            case "html": 
            case "htm": 
            case "shtml": {
                contentType = "text/html";
                break;
            }
            case "xml": {
                contentType = "text/xml";
            }
        }
        response.addHeader("Content-Type", contentType);
        try {
            if (isDeflated) {
                if (isDeflationPossible || file.length() > 0xA00000L) {
                    response.addHeader("Content-Encoding", "gzip");
                    response.setData(new FileInputStream(file));
                    return response;
                }
                response.setData(new GZIPInputStream(new FileInputStream(file)));
                return response;
            }
            if (isDeflationPossible && file.length() > 10240L && file.length() < 0xA00000L) {
                FileInputStream fis = new FileInputStream(file);
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                GZIPOutputStream zos = new GZIPOutputStream(byteOut);
                IOUtils.copyLarge((InputStream)fis, (OutputStream)zos);
                zos.close();
                fis.close();
                byte[] compressedData = byteOut.toByteArray();
                response.setData(new ByteArrayInputStream(compressedData));
                response.addHeader("Content-Encoding", "gzip");
                return response;
            }
            response.setData(new FileInputStream(file));
            return response;
        }
        catch (FileNotFoundException e) {
            return new HttpResponse(HttpStatusCode.NOT_FOUND);
        }
        catch (IOException e) {
            return new HttpResponse(HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private static String timestampToString(long time) {
        return DateFormatUtils.format((long)time, (String)"EEE, dd MMM yyy HH:mm:ss 'GMT'", (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.ENGLISH);
    }

    private static long stringToTimestamp(String timeString) throws IllegalArgumentException {
        try {
            int day = Integer.parseInt(timeString.substring(5, 7));
            int month = 1;
            switch (timeString.substring(8, 11)) {
                case "Jan": {
                    month = 0;
                    break;
                }
                case "Feb": {
                    month = 1;
                    break;
                }
                case "Mar": {
                    month = 2;
                    break;
                }
                case "Apr": {
                    month = 3;
                    break;
                }
                case "May": {
                    month = 4;
                    break;
                }
                case "Jun": {
                    month = 5;
                    break;
                }
                case "Jul": {
                    month = 6;
                    break;
                }
                case "Aug": {
                    month = 7;
                    break;
                }
                case "Sep": {
                    month = 8;
                    break;
                }
                case "Oct": {
                    month = 9;
                    break;
                }
                case "Nov": {
                    month = 10;
                    break;
                }
                case "Dec": {
                    month = 11;
                }
            }
            int year = Integer.parseInt(timeString.substring(12, 16));
            int hour = Integer.parseInt(timeString.substring(17, 19));
            int min2 = Integer.parseInt(timeString.substring(20, 22));
            int sec = Integer.parseInt(timeString.substring(23, 25));
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            cal.set(year, month, day, hour, min2, sec);
            return cal.getTimeInMillis();
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

