/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.rendermanager;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector2l;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.world.Grid;
import de.bluecolored.bluemap.core.world.Region;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.stream.Collectors;

@DebugDump
public class WorldRegionRenderTask
implements RenderTask {
    private final BmMap map;
    private final Vector2i worldRegion;
    private final boolean force;
    private Deque<Vector2i> tiles;
    private int tileCount;
    private long startTime;
    private volatile int atWork;
    private volatile boolean cancelled;

    public WorldRegionRenderTask(BmMap map, Vector2i worldRegion) {
        this(map, worldRegion, false);
    }

    public WorldRegionRenderTask(BmMap map, Vector2i worldRegion, boolean force) {
        this.map = map;
        this.worldRegion = worldRegion;
        this.force = force;
        this.tiles = null;
        this.tileCount = -1;
        this.startTime = -1L;
        this.atWork = 0;
        this.cancelled = false;
    }

    private synchronized void init() {
        HashSet<Vector2l> tileSet = new HashSet<Vector2l>();
        this.startTime = System.currentTimeMillis();
        long changesSince = 0L;
        if (!this.force) {
            changesSince = this.map.getRenderState().getRenderTime(this.worldRegion);
        }
        Region region = this.map.getWorld().getRegion(this.worldRegion.getX(), this.worldRegion.getY());
        Collection<Vector2i> chunks = region.listChunks(changesSince);
        Grid tileGrid = this.map.getHiresModelManager().getTileGrid();
        Grid chunkGrid = this.map.getWorld().getChunkGrid();
        for (Vector2i chunk : chunks) {
            Vector2i tileMin = chunkGrid.getCellMin(chunk, tileGrid);
            Vector2i tileMax = chunkGrid.getCellMax(chunk, tileGrid);
            for (int x = tileMin.getX(); x <= tileMax.getX(); ++x) {
                for (int z = tileMin.getY(); z <= tileMax.getY(); ++z) {
                    tileSet.add(new Vector2l(x, z));
                }
            }
        }
        this.tileCount = tileSet.size();
        this.tiles = tileSet.stream().sorted(WorldRegionRenderTask::compareVec2L).map(Vector2l::toInt).collect(Collectors.toCollection(ArrayDeque::new));
        if (this.tiles.isEmpty()) {
            this.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() {
        Vector2i tile;
        if (this.cancelled) {
            return;
        }
        WorldRegionRenderTask worldRegionRenderTask = this;
        synchronized (worldRegionRenderTask) {
            if (this.tiles == null) {
                this.init();
            }
            if (this.tiles.isEmpty()) {
                return;
            }
            tile = this.tiles.pollFirst();
            ++this.atWork;
        }
        if (this.isAllChunksInTileGenerated(tile)) {
            this.map.renderTile(tile);
        }
        worldRegionRenderTask = this;
        synchronized (worldRegionRenderTask) {
            --this.atWork;
            if (this.atWork <= 0 && this.tiles.isEmpty() && !this.cancelled) {
                this.complete();
            }
        }
    }

    private boolean isAllChunksInTileGenerated(Vector2i tile) {
        Grid tileGrid = this.map.getHiresModelManager().getTileGrid();
        Grid chunkGrid = this.map.getWorld().getChunkGrid();
        Vector2i minChunk = tileGrid.getCellMin(tile, chunkGrid);
        Vector2i maxChunk = tileGrid.getCellMax(tile, chunkGrid);
        for (int x = minChunk.getX(); x <= maxChunk.getX(); ++x) {
            for (int z = minChunk.getY(); z <= maxChunk.getY(); ++z) {
                if (this.map.getWorld().getChunk(x, z).isGenerated()) continue;
                return false;
            }
        }
        return true;
    }

    private void complete() {
        this.map.getRenderState().setRenderTime(this.worldRegion, this.startTime);
    }

    @Override
    @DebugDump
    public synchronized boolean hasMoreWork() {
        return !this.cancelled && (this.tiles == null || !this.tiles.isEmpty());
    }

    @Override
    @DebugDump
    public double estimateProgress() {
        if (this.tiles == null) {
            return 0.0;
        }
        if (this.tileCount == 0) {
            return 1.0;
        }
        double remainingTiles = this.tiles.size();
        return 1.0 - remainingTiles / (double)this.tileCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.cancelled = true;
        WorldRegionRenderTask worldRegionRenderTask = this;
        synchronized (worldRegionRenderTask) {
            if (this.tiles != null) {
                this.tiles.clear();
            }
        }
    }

    public BmMap getMap() {
        return this.map;
    }

    public Vector2i getWorldRegion() {
        return this.worldRegion;
    }

    public boolean isForce() {
        return this.force;
    }

    @Override
    public String getDescription() {
        return "Update region " + this.getWorldRegion() + " for map '" + this.map.getId() + "'";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldRegionRenderTask that = (WorldRegionRenderTask)o;
        return this.force == that.force && this.map.getId().equals(that.map.getId()) && this.worldRegion.equals(that.worldRegion);
    }

    public int hashCode() {
        return this.worldRegion.hashCode();
    }

    public static Comparator<WorldRegionRenderTask> defaultComparator(Vector2i centerRegion) {
        return (task1, task2) -> {
            Vector2l task1Rel = new Vector2l(task1.worldRegion.getX() - centerRegion.getX(), task1.worldRegion.getY() - centerRegion.getY());
            Vector2l task2Rel = new Vector2l(task2.worldRegion.getX() - centerRegion.getX(), task2.worldRegion.getY() - centerRegion.getY());
            return WorldRegionRenderTask.compareVec2L(task1Rel, task2Rel);
        };
    }

    private static int compareVec2L(Vector2l v1, Vector2l v2) {
        return Long.signum(v1.lengthSquared() - v2.lengthSquared());
    }
}

