/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.rendermanager;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.common.rendermanager.CombinedRenderTask;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.world.Grid;
import de.bluecolored.bluemap.core.world.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@DebugDump
public class MapUpdateTask
extends CombinedRenderTask<WorldRegionRenderTask> {
    private final BmMap map;
    private final Collection<Vector2i> regions;

    public MapUpdateTask(BmMap map) {
        this(map, MapUpdateTask.getRegions(map.getWorld()));
    }

    public MapUpdateTask(BmMap map, boolean force) {
        this(map, MapUpdateTask.getRegions(map.getWorld()), force);
    }

    public MapUpdateTask(BmMap map, Vector2i center, int radius) {
        this(map, MapUpdateTask.getRegions(map.getWorld(), center, radius));
    }

    public MapUpdateTask(BmMap map, Vector2i center, int radius, boolean force) {
        this(map, MapUpdateTask.getRegions(map.getWorld(), center, radius), force);
    }

    public MapUpdateTask(BmMap map, Collection<Vector2i> regions) {
        this(map, regions, false);
    }

    public MapUpdateTask(BmMap map, Collection<Vector2i> regions, boolean force) {
        super("Update map '" + map.getId() + "'", MapUpdateTask.createTasks(map, regions, force));
        this.map = map;
        this.regions = Collections.unmodifiableCollection(new ArrayList<Vector2i>(regions));
    }

    public BmMap getMap() {
        return this.map;
    }

    public Collection<Vector2i> getRegions() {
        return this.regions;
    }

    private static Collection<WorldRegionRenderTask> createTasks(BmMap map, Collection<Vector2i> regions, boolean force) {
        ArrayList<WorldRegionRenderTask> tasks = new ArrayList<WorldRegionRenderTask>(regions.size());
        regions.forEach(region -> tasks.add(new WorldRegionRenderTask(map, (Vector2i)region, force)));
        World world = map.getWorld();
        Vector2i spawnPoint = world.getSpawnPoint().toVector2(true);
        Grid regionGrid = world.getRegionGrid();
        Vector2i spawnRegion = regionGrid.getCell(spawnPoint);
        tasks.sort(WorldRegionRenderTask.defaultComparator(spawnRegion));
        return tasks;
    }

    private static List<Vector2i> getRegions(World world) {
        return MapUpdateTask.getRegions(world, null, -1);
    }

    private static List<Vector2i> getRegions(World world, Vector2i center, int radius) {
        if (center == null || radius < 0) {
            return new ArrayList<Vector2i>(world.listRegions());
        }
        ArrayList<Vector2i> regions = new ArrayList<Vector2i>();
        Grid regionGrid = world.getRegionGrid();
        Vector2i halfCell = regionGrid.getGridSize().div(2);
        int increasedRadiusSquared = (int)Math.pow((double)radius + Math.ceil(halfCell.length()), 2.0);
        for (Vector2i region : world.listRegions()) {
            Vector2i min2 = regionGrid.getCellMin(region);
            Vector2i regionCenter = min2.add(halfCell);
            if (regionCenter.distanceSquared(center) > increasedRadiusSquared) continue;
            regions.add(region);
        }
        return regions;
    }
}

