/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.rendermanager;

import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.util.FileUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.stream.Collectors;

public class MapPurgeTask
implements RenderTask {
    @DebugDump
    private final BmMap map;
    @DebugDump
    private final Path directory;
    @DebugDump
    private final int subFilesCount;
    private final LinkedList<Path> subFiles;
    @DebugDump
    private volatile boolean hasMoreWork;
    @DebugDump
    private volatile boolean cancelled;

    public MapPurgeTask(Path mapDirectory) throws IOException {
        this(null, mapDirectory);
    }

    public MapPurgeTask(BmMap map) throws IOException {
        this(map, map.getFileRoot());
    }

    private MapPurgeTask(BmMap map, Path directory) throws IOException {
        this.map = map;
        this.directory = directory;
        this.subFiles = Files.walk(directory, 3, new FileVisitOption[0]).collect(Collectors.toCollection(LinkedList::new));
        this.subFilesCount = this.subFiles.size();
        this.hasMoreWork = true;
        this.cancelled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() throws Exception {
        MapPurgeTask mapPurgeTask = this;
        synchronized (mapPurgeTask) {
            if (!this.hasMoreWork) {
                return;
            }
            this.hasMoreWork = false;
        }
        try {
            while (!this.subFiles.isEmpty()) {
                Path subFile = this.subFiles.getLast();
                FileUtils.delete(subFile.toFile());
                this.subFiles.removeLast();
                if (!this.cancelled) continue;
                return;
            }
            FileUtils.delete(this.directory.toFile());
        }
        finally {
            if (this.map != null) {
                this.map.getRenderState().reset();
            }
        }
    }

    @Override
    public boolean hasMoreWork() {
        return this.hasMoreWork;
    }

    @Override
    public double estimateProgress() {
        return 1.0 - (double)this.subFiles.size() / (double)this.subFilesCount;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public boolean contains(RenderTask task) {
        if (task == this) {
            return true;
        }
        if (task instanceof MapPurgeTask) {
            return ((MapPurgeTask)task).directory.toAbsolutePath().normalize().startsWith(this.directory.toAbsolutePath().normalize());
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Purge Map " + this.directory.getFileName();
    }
}

