/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin.skins;

import de.bluecolored.bluemap.common.plugin.serverinterface.ServerEventListener;
import de.bluecolored.bluemap.common.plugin.skins.PlayerSkin;
import de.bluecolored.bluemap.core.debug.DebugDump;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;

@DebugDump
public class PlayerSkinUpdater
implements ServerEventListener {
    private File storageFolder;
    private File defaultSkin;
    private final Map<UUID, PlayerSkin> skins;

    public PlayerSkinUpdater(File storageFolder, File defaultSkin) throws IOException {
        this.storageFolder = storageFolder;
        this.defaultSkin = defaultSkin;
        this.skins = new ConcurrentHashMap<UUID, PlayerSkin>();
        FileUtils.forceMkdir((File)this.storageFolder);
    }

    public void updateSkin(UUID playerUuid) {
        PlayerSkin skin = this.skins.get(playerUuid);
        if (skin == null) {
            skin = new PlayerSkin(playerUuid);
            this.skins.put(playerUuid, skin);
        }
        skin.update(this.storageFolder, this.defaultSkin);
    }

    @Override
    public void onPlayerJoin(UUID playerUuid) {
        this.updateSkin(playerUuid);
    }

    public File getStorageFolder() {
        return this.storageFolder;
    }

    public void setStorageFolder(File storageFolder) {
        this.storageFolder = storageFolder;
    }

    public File getDefaultSkin() {
        return this.defaultSkin;
    }

    public void setDefaultSkin(File defaultSkin) {
        this.defaultSkin = defaultSkin;
    }
}

