/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin.skins;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.bluemap.core.logger.Logger;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.imageio.ImageIO;

@DebugDump
public class PlayerSkin {
    private final UUID uuid;
    private long lastUpdate;

    public PlayerSkin(UUID uuid) {
        this.uuid = uuid;
        this.lastUpdate = -1L;
    }

    public void update(File storageFolder, File fallback) {
        long now = System.currentTimeMillis();
        if (this.lastUpdate > 0L && this.lastUpdate + 600000L > now) {
            return;
        }
        this.lastUpdate = now;
        new Thread(() -> {
            BufferedImage head = null;
            try {
                Future<BufferedImage> futureSkin = this.loadSkin();
                BufferedImage skin = futureSkin.get(10L, TimeUnit.SECONDS);
                head = this.createHead(skin);
            }
            catch (ExecutionException | TimeoutException e) {
                Logger.global.logDebug("Failed to load player-skin from mojang-servers: " + e);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                if (head == null) {
                    head = ImageIO.read(fallback);
                }
                ImageIO.write((RenderedImage)head, "png", new File(storageFolder, this.uuid.toString() + ".png"));
            }
            catch (IOException e) {
                Logger.global.logError("Failed to write player-head image!", e);
            }
        }).start();
    }

    public BufferedImage createHead(BufferedImage skinTexture) {
        BufferedImage head = new BufferedImage(8, 8, skinTexture.getType());
        BufferedImage layer1 = skinTexture.getSubimage(8, 8, 8, 8);
        BufferedImage layer2 = skinTexture.getSubimage(40, 8, 8, 8);
        try {
            Graphics2D g2 = head.createGraphics();
            g2.drawImage((Image)layer1, 0, 0, null);
            g2.drawImage((Image)layer2, 0, 0, null);
        }
        catch (Throwable t) {
            Logger.global.noFloodWarning("headless-graphics-fail", "Could not access Graphics2D to render player-skin texture. Try adding '-Djava.awt.headless=true' to your startup flags or ignore this warning.");
            layer1.copyData(head.getRaster());
        }
        return head;
    }

    public Future<BufferedImage> loadSkin() {
        CompletableFuture<BufferedImage> image = new CompletableFuture<BufferedImage>();
        new Thread(() -> {
            try {
                JsonParser parser = new JsonParser();
                try (Reader reader = this.requestProfileJson();){
                    String textureInfoJson = this.readTextureInfoJson(parser.parse(reader));
                    String textureUrl = this.readTextureUrl(parser.parse(textureInfoJson));
                    image.complete(ImageIO.read(new URL(textureUrl)));
                }
            }
            catch (IOException e) {
                image.completeExceptionally(e);
            }
        }).start();
        return image;
    }

    private Reader requestProfileJson() throws IOException {
        URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + this.uuid);
        return new InputStreamReader(url.openStream());
    }

    private String readTextureInfoJson(JsonElement json) throws IOException {
        try {
            JsonArray properties = json.getAsJsonObject().getAsJsonArray("properties");
            for (JsonElement element : properties) {
                if (!element.getAsJsonObject().get("name").getAsString().equals("textures")) continue;
                return new String(Base64.getDecoder().decode(element.getAsJsonObject().get("value").getAsString().getBytes()));
            }
            throw new IOException("No texture info found!");
        }
        catch (ClassCastException | IllegalStateException | NullPointerException e) {
            throw new IOException(e);
        }
    }

    private String readTextureUrl(JsonElement json) throws IOException {
        try {
            return json.getAsJsonObject().getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
        }
        catch (ClassCastException | IllegalStateException | NullPointerException e) {
            throw new IOException(e);
        }
    }
}

