/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin.commands;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.marker.Marker;
import de.bluecolored.bluemap.api.marker.MarkerAPI;
import de.bluecolored.bluemap.api.marker.MarkerSet;
import de.bluecolored.bluemap.api.marker.POIMarker;
import de.bluecolored.bluemap.common.plugin.commands.AbstractSuggestionProvider;
import de.bluecolored.bluemap.core.logger.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;

public class MarkerIdSuggestionProvider<S>
extends AbstractSuggestionProvider<S> {
    private static MarkerIdSuggestionProvider<?> instance;
    private MarkerAPI markerApi;
    private long lastUpdate = -1L;

    private MarkerIdSuggestionProvider() {
    }

    @Override
    public Collection<String> getPossibleValues() {
        MarkerSet set;
        HashSet<String> values = new HashSet<String>();
        if (this.markerApi == null || this.lastUpdate + 60000L < System.currentTimeMillis()) {
            this.lastUpdate = System.currentTimeMillis();
            Optional<BlueMapAPI> api = BlueMapAPI.getInstance();
            if (!api.isPresent()) {
                return values;
            }
            try {
                this.markerApi = api.get().getMarkerAPI();
            }
            catch (IOException e) {
                Logger.global.noFloodError("0FEz5tm345rf", "Failed to load MarkerAPI!", e);
                return values;
            }
        }
        if ((set = (MarkerSet)this.markerApi.getMarkerSet("markers").orElse(null)) != null) {
            for (Marker marker : set.getMarkers()) {
                if (!(marker instanceof POIMarker)) continue;
                values.add(marker.getId());
            }
        }
        return values;
    }

    public void forceUpdate() {
        this.lastUpdate = -1L;
    }

    public static <S> MarkerIdSuggestionProvider<S> getInstance() {
        if (instance == null) {
            instance = new MarkerIdSuggestionProvider<S>();
        }
        return instance;
    }
}

