/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin.commands;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.marker.MarkerAPI;
import de.bluecolored.bluemap.api.marker.MarkerSet;
import de.bluecolored.bluemap.api.marker.POIMarker;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.plugin.PluginState;
import de.bluecolored.bluemap.common.plugin.commands.CommandHelper;
import de.bluecolored.bluemap.common.plugin.commands.MapSuggestionProvider;
import de.bluecolored.bluemap.common.plugin.commands.MarkerIdSuggestionProvider;
import de.bluecolored.bluemap.common.plugin.commands.TaskRefSuggestionProvider;
import de.bluecolored.bluemap.common.plugin.commands.WorldOrMapSuggestionProvider;
import de.bluecolored.bluemap.common.plugin.commands.WorldSuggestionProvider;
import de.bluecolored.bluemap.common.plugin.serverinterface.CommandSource;
import de.bluecolored.bluemap.common.plugin.text.Text;
import de.bluecolored.bluemap.common.plugin.text.TextColor;
import de.bluecolored.bluemap.common.plugin.text.TextFormat;
import de.bluecolored.bluemap.common.rendermanager.MapPurgeTask;
import de.bluecolored.bluemap.common.rendermanager.MapUpdateTask;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.MinecraftVersion;
import de.bluecolored.bluemap.core.debug.StateDumper;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.map.MapRenderState;
import de.bluecolored.bluemap.core.resourcepack.ParseResourceException;
import de.bluecolored.bluemap.core.world.Block;
import de.bluecolored.bluemap.core.world.World;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class Commands<S> {
    public static final String DEFAULT_MARKER_SET_ID = "markers";
    private final Plugin plugin;
    private final CommandDispatcher<S> dispatcher;
    private final Function<S, CommandSource> commandSourceInterface;
    private final CommandHelper helper;

    public Commands(Plugin plugin, CommandDispatcher<S> dispatcher, Function<S, CommandSource> commandSourceInterface) {
        this.plugin = plugin;
        this.dispatcher = dispatcher;
        this.commandSourceInterface = commandSourceInterface;
        this.helper = new CommandHelper(plugin);
        this.init();
    }

    public void init() {
        LiteralCommandNode baseCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("bluemap").requires(this.requirementsUnloaded("bluemap.status"))).executes(this::statusCommand)).build();
        LiteralCommandNode versionCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("version").requires(this.requirementsUnloaded("bluemap.version"))).executes(this::versionCommand)).build();
        LiteralCommandNode helpCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("help").requires(this.requirementsUnloaded("bluemap.help"))).executes(this::helpCommand)).build();
        LiteralCommandNode reloadCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("reload").requires(this.requirementsUnloaded("bluemap.reload"))).executes(this::reloadCommand)).build();
        LiteralCommandNode debugCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("debug").requires(this.requirements("bluemap.debug"))).then(((LiteralArgumentBuilder)this.literal("block").executes(this::debugBlockCommand)).then(this.argument("world", (ArgumentType)StringArgumentType.string()).suggests(new WorldSuggestionProvider(this.plugin)).then(this.argument("x", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("y", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("z", (ArgumentType)DoubleArgumentType.doubleArg()).executes(this::debugBlockCommand))))))).then(((LiteralArgumentBuilder)this.literal("flush").executes(this::debugFlushCommand)).then(this.argument("world", (ArgumentType)StringArgumentType.string()).suggests(new WorldSuggestionProvider(this.plugin)).executes(this::debugFlushCommand)))).then(this.literal("cache").executes(this::debugClearCacheCommand))).then(this.literal("dump").executes(this::debugDumpCommand))).build();
        LiteralCommandNode stopCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("stop").requires(this.requirements("bluemap.stop"))).executes(this::stopCommand)).build();
        LiteralCommandNode startCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("start").requires(this.requirements("bluemap.start"))).executes(this::startCommand)).build();
        LiteralCommandNode freezeCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("freeze").requires(this.requirements("bluemap.freeze"))).then(this.argument("map", (ArgumentType)StringArgumentType.string()).suggests(new MapSuggestionProvider(this.plugin)).executes(this::freezeCommand))).build();
        LiteralCommandNode unfreezeCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("unfreeze").requires(this.requirements("bluemap.freeze"))).then(this.argument("map", (ArgumentType)StringArgumentType.string()).suggests(new MapSuggestionProvider(this.plugin)).executes(this::unfreezeCommand))).build();
        LiteralCommandNode forceUpdateCommand = this.addRenderArguments((LiteralArgumentBuilder)this.literal("force-update").requires(this.requirements("bluemap.update.force")), this::forceUpdateCommand).build();
        LiteralCommandNode updateCommand = this.addRenderArguments((LiteralArgumentBuilder)this.literal("update").requires(this.requirements("bluemap.update")), this::updateCommand).build();
        LiteralCommandNode purgeCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("purge").requires(this.requirements("bluemap.purge"))).then(this.argument("map", (ArgumentType)StringArgumentType.string()).suggests(new MapSuggestionProvider(this.plugin)).executes(this::purgeCommand))).build();
        LiteralCommandNode cancelCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("cancel").requires(this.requirements("bluemap.cancel"))).executes(this::cancelCommand)).then(this.argument("task-ref", (ArgumentType)StringArgumentType.string()).suggests(new TaskRefSuggestionProvider(this.helper)).executes(this::cancelCommand))).build();
        LiteralCommandNode worldsCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("worlds").requires(this.requirements("bluemap.status"))).executes(this::worldsCommand)).build();
        LiteralCommandNode mapsCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("maps").requires(this.requirements("bluemap.status"))).executes(this::mapsCommand)).build();
        LiteralCommandNode markerCommand = ((LiteralArgumentBuilder)this.literal("marker").requires(this.requirements("bluemap.marker"))).build();
        LiteralCommandNode createMarkerCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("create").requires(this.requirements("bluemap.marker"))).then(this.argument("id", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)this.argument("map", (ArgumentType)StringArgumentType.string()).suggests(new MapSuggestionProvider(this.plugin)).then(this.argument("label", (ArgumentType)StringArgumentType.string()).executes(this::createMarkerCommand))).then(this.argument("x", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("y", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("z", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("label", (ArgumentType)StringArgumentType.string()).executes(this::createMarkerCommand)))))))).build();
        LiteralCommandNode removeMarkerCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("remove").requires(this.requirements("bluemap.marker"))).then(this.argument("id", (ArgumentType)StringArgumentType.word()).suggests(MarkerIdSuggestionProvider.getInstance()).executes(this::removeMarkerCommand))).build();
        LiteralCommandNode listMarkersCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("list").requires(this.requirements("bluemap.marker"))).executes(this::listMarkersCommand)).build();
        this.dispatcher.getRoot().addChild((CommandNode)baseCommand);
        baseCommand.addChild((CommandNode)versionCommand);
        baseCommand.addChild((CommandNode)helpCommand);
        baseCommand.addChild((CommandNode)reloadCommand);
        baseCommand.addChild((CommandNode)debugCommand);
        baseCommand.addChild((CommandNode)stopCommand);
        baseCommand.addChild((CommandNode)startCommand);
        baseCommand.addChild((CommandNode)freezeCommand);
        baseCommand.addChild((CommandNode)unfreezeCommand);
        baseCommand.addChild((CommandNode)forceUpdateCommand);
        baseCommand.addChild((CommandNode)updateCommand);
        baseCommand.addChild((CommandNode)cancelCommand);
        baseCommand.addChild((CommandNode)purgeCommand);
        baseCommand.addChild((CommandNode)worldsCommand);
        baseCommand.addChild((CommandNode)mapsCommand);
        baseCommand.addChild((CommandNode)markerCommand);
        markerCommand.addChild((CommandNode)createMarkerCommand);
        markerCommand.addChild((CommandNode)removeMarkerCommand);
        markerCommand.addChild((CommandNode)listMarkersCommand);
    }

    private <B extends ArgumentBuilder<S, B>> B addRenderArguments(B builder, Command<S> command) {
        return (B)builder.executes(command).then(this.argument("radius", (ArgumentType)IntegerArgumentType.integer()).executes(command)).then(this.argument("x", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("z", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("radius", (ArgumentType)IntegerArgumentType.integer()).executes(command)))).then(((RequiredArgumentBuilder)this.argument("world|map", (ArgumentType)StringArgumentType.string()).suggests(new WorldOrMapSuggestionProvider(this.plugin)).executes(command)).then(this.argument("x", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("z", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("radius", (ArgumentType)IntegerArgumentType.integer()).executes(command)))));
    }

    private Predicate<S> requirements(String permission) {
        return s2 -> {
            CommandSource source = this.commandSourceInterface.apply(s2);
            return this.plugin.isLoaded() && source.hasPermission(permission);
        };
    }

    private Predicate<S> requirementsUnloaded(String permission) {
        return s2 -> {
            CommandSource source = this.commandSourceInterface.apply(s2);
            return source.hasPermission(permission);
        };
    }

    private LiteralArgumentBuilder<S> literal(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    private <T> RequiredArgumentBuilder<S, T> argument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    private <T> Optional<T> getOptionalArgument(CommandContext<S> context, String argumentName, Class<T> type) {
        try {
            return Optional.of(context.getArgument(argumentName, type));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    private Optional<World> parseWorld(String worldName) {
        for (World world : this.plugin.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(worldName)) continue;
            return Optional.of(world);
        }
        return Optional.empty();
    }

    private Optional<BmMap> parseMap(String mapId) {
        for (BmMap map : this.plugin.getMapTypes()) {
            if (!map.getId().equalsIgnoreCase(mapId)) continue;
            return Optional.of(map);
        }
        return Optional.empty();
    }

    public int statusCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        if (!this.plugin.isLoaded()) {
            source.sendMessage(Text.of(TextColor.RED, "BlueMap is not loaded! Try /bluemap reload"));
            return 0;
        }
        source.sendMessages(this.helper.createStatusMessage());
        return 1;
    }

    public int versionCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        int renderThreadCount = 0;
        if (this.plugin.isLoaded()) {
            renderThreadCount = this.plugin.getRenderManager().getWorkerThreadCount();
        }
        source.sendMessage(Text.of(new Object[]{TextFormat.BOLD, TextColor.BLUE, "Version: ", TextColor.WHITE, BlueMap.VERSION}));
        source.sendMessage(Text.of(new Object[]{TextColor.GRAY, "Commit: ", TextColor.WHITE, BlueMap.GIT_HASH + " (" + BlueMap.GIT_CLEAN + ")"}));
        source.sendMessage(Text.of(new Object[]{TextColor.GRAY, "Implementation: ", TextColor.WHITE, this.plugin.getImplementationType()}));
        source.sendMessage(Text.of(new Object[]{TextColor.GRAY, "Minecraft compatibility: ", TextColor.WHITE, this.plugin.getMinecraftVersion().getVersionString(), TextColor.GRAY, " (" + this.plugin.getMinecraftVersion().getResource().getVersion().getVersionString() + ")"}));
        source.sendMessage(Text.of(new Object[]{TextColor.GRAY, "Render-threads: ", TextColor.WHITE, renderThreadCount}));
        source.sendMessage(Text.of(new Object[]{TextColor.GRAY, "Available processors: ", TextColor.WHITE, Runtime.getRuntime().availableProcessors()}));
        source.sendMessage(Text.of(new Object[]{TextColor.GRAY, "Available memory: ", TextColor.WHITE, Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MiB"}));
        if (this.plugin.getMinecraftVersion().isAtLeast(new MinecraftVersion(1, 15))) {
            String clipboardValue = "Version: " + BlueMap.VERSION + "\nCommit: " + BlueMap.GIT_HASH + " (" + BlueMap.GIT_CLEAN + ")\nImplementation: " + this.plugin.getImplementationType() + "\nMinecraft compatibility: " + this.plugin.getMinecraftVersion().getVersionString() + " (" + this.plugin.getMinecraftVersion().getResource().getVersion().getVersionString() + ")\nRender-threads: " + renderThreadCount + "\nAvailable processors: " + Runtime.getRuntime().availableProcessors() + "\nAvailable memory: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MiB";
            source.sendMessage(Text.of(TextColor.DARK_GRAY, "[copy to clipboard]").setClickAction(Text.ClickAction.COPY_TO_CLIPBOARD, clipboardValue).setHoverText(Text.of(new Object[]{TextColor.GRAY, "click to copy the above text .. ", TextFormat.ITALIC, TextColor.GRAY, "duh!"})));
        }
        return 1;
    }

    public int helpCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        source.sendMessage(Text.of(TextColor.BLUE, "BlueMap Commands:"));
        for (String usage : this.dispatcher.getAllUsage(this.dispatcher.getRoot().getChild("bluemap"), context.getSource(), true)) {
            String[] arguments;
            Text usageText = Text.of(TextColor.GREEN, "/bluemap");
            for (String arg : arguments = usage.split(" ")) {
                if (arg.isEmpty()) continue;
                if (arg.charAt(0) == '<' && arg.charAt(arg.length() - 1) == '>') {
                    usageText.addChild(Text.of(TextColor.GRAY, " " + arg));
                    continue;
                }
                usageText.addChild(Text.of(TextColor.WHITE, " " + arg));
            }
            source.sendMessage(usageText);
        }
        source.sendMessage(Text.of(TextColor.BLUE, "\nOpen this link to get a description for each command:\n").addChild(Text.of(TextColor.GRAY, "https://bluecolo.red/bluemap-commands").setClickAction(Text.ClickAction.OPEN_URL, "https://bluecolo.red/bluemap-commands")));
        return 1;
    }

    public int reloadCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        source.sendMessage(Text.of(TextColor.GOLD, "Reloading BlueMap..."));
        new Thread(() -> {
            try {
                this.plugin.reload();
                if (this.plugin.isLoaded()) {
                    source.sendMessage(Text.of(TextColor.GREEN, "BlueMap reloaded!"));
                } else {
                    source.sendMessage(Text.of(TextColor.RED, "Could not load BlueMap! See the console for details!"));
                }
            }
            catch (ParseResourceException | IOException | RuntimeException ex) {
                Logger.global.logError("Failed to reload BlueMap!", ex);
                source.sendMessage(Text.of(TextColor.RED, "There was an error reloading BlueMap! See the console for details!"));
            }
        }).start();
        return 1;
    }

    public int debugClearCacheCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        for (World world : this.plugin.getWorlds()) {
            world.invalidateChunkCache();
        }
        source.sendMessage(Text.of(TextColor.GREEN, "All caches cleared!"));
        return 1;
    }

    public int debugFlushCommand(CommandContext<S> context) {
        World world;
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        Optional<String> worldName = this.getOptionalArgument(context, "world", String.class);
        if (worldName.isPresent()) {
            world = this.parseWorld(worldName.get()).orElse(null);
            if (world == null) {
                source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no ", this.helper.worldHelperHover(), " with this name: ", TextColor.WHITE, worldName.get()}));
                return 0;
            }
        } else {
            world = source.getWorld().orElse(null);
            if (world == null) {
                source.sendMessage(Text.of(TextColor.RED, "Can't detect a location from this command-source, you'll have to define a world!"));
                return 0;
            }
        }
        new Thread(() -> {
            source.sendMessage(Text.of(TextColor.GOLD, "Saving world and flushing changes..."));
            try {
                if (this.plugin.flushWorldUpdates(world.getUUID())) {
                    source.sendMessage(Text.of(TextColor.GREEN, "Successfully saved and flushed all changes."));
                } else {
                    source.sendMessage(Text.of(TextColor.RED, "This operation is not supported by this implementation (" + this.plugin.getImplementationType() + ")"));
                }
            }
            catch (IOException ex) {
                source.sendMessage(Text.of(TextColor.RED, "There was an unexpected exception trying to save the world. Please check the console for more details..."));
                Logger.global.logError("Unexpected exception trying to save the world!", ex);
            }
        }).start();
        return 1;
    }

    public int debugBlockCommand(CommandContext<S> context) {
        Vector3d position;
        World world;
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        Optional<String> worldName = this.getOptionalArgument(context, "world", String.class);
        Optional<Double> x = this.getOptionalArgument(context, "x", Double.class);
        Optional<Double> y = this.getOptionalArgument(context, "y", Double.class);
        Optional<Double> z = this.getOptionalArgument(context, "z", Double.class);
        if (worldName.isPresent() && x.isPresent() && y.isPresent() && z.isPresent()) {
            world = this.parseWorld(worldName.get()).orElse(null);
            position = new Vector3d(x.get(), y.get(), z.get());
            if (world == null) {
                source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no ", this.helper.worldHelperHover(), " with this name: ", TextColor.WHITE, worldName.get()}));
                return 0;
            }
        } else {
            world = source.getWorld().orElse(null);
            position = source.getPosition().orElse(null);
            if (world == null || position == null) {
                source.sendMessage(Text.of(TextColor.RED, "Can't detect a location from this command-source, you'll have to define a world and position!"));
                return 0;
            }
        }
        new Thread(() -> {
            Vector3i blockPos = position.floor().toInt();
            Block block = new Block(world, blockPos.getX(), blockPos.getY(), blockPos.getZ());
            Object blockBelow = new Block(null, 0, 0, 0).copy(block, 0, -1, 0);
            block.getBlockState();
            block.getBiomeId();
            block.getLightData();
            ((Block)blockBelow).getBlockState();
            ((Block)blockBelow).getBiomeId();
            ((Block)blockBelow).getLightData();
            source.sendMessages(Arrays.asList(Text.of(new Object[]{TextColor.GOLD, "Block at you: ", TextColor.WHITE, block}), Text.of(new Object[]{TextColor.GOLD, "Block below you: ", TextColor.WHITE, blockBelow})));
        }).start();
        return 1;
    }

    public int debugDumpCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        try {
            Path file = this.plugin.getCoreConfig().getDataFolder().toPath().resolve("dump.json");
            StateDumper.global().dump(file);
            source.sendMessage(Text.of(TextColor.GREEN, "Dump created at: " + file));
            return 1;
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to create dump!", ex);
            source.sendMessage(Text.of(TextColor.RED, "Exception trying to create dump! See console for details."));
            return 0;
        }
    }

    public int stopCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        if (!this.plugin.getRenderManager().isRunning()) {
            source.sendMessage(Text.of(TextColor.RED, "Render-Threads are already stopped!"));
            return 0;
        }
        new Thread(() -> {
            this.plugin.getPluginState().setRenderThreadsEnabled(false);
            this.plugin.getRenderManager().stop();
            source.sendMessage(Text.of(TextColor.GREEN, "Render-Threads stopped!"));
            this.plugin.save();
        }).start();
        return 1;
    }

    public int startCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        if (this.plugin.getRenderManager().isRunning()) {
            source.sendMessage(Text.of(TextColor.RED, "Render-Threads are already running!"));
            return 0;
        }
        new Thread(() -> {
            this.plugin.getPluginState().setRenderThreadsEnabled(true);
            this.plugin.getRenderManager().start(this.plugin.getCoreConfig().getRenderThreadCount());
            source.sendMessage(Text.of(TextColor.GREEN, "Render-Threads started!"));
            this.plugin.save();
        }).start();
        return 1;
    }

    public int freezeCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        String mapString = (String)context.getArgument("map", String.class);
        BmMap map = this.parseMap(mapString).orElse(null);
        if (map == null) {
            source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no ", this.helper.mapHelperHover(), " with this name: ", TextColor.WHITE, mapString}));
            return 0;
        }
        PluginState.MapState mapState = this.plugin.getPluginState().getMapState(map);
        if (!mapState.isUpdateEnabled()) {
            source.sendMessage(Text.of(TextColor.RED, "This map is already frozen!"));
            return 0;
        }
        new Thread(() -> {
            mapState.setUpdateEnabled(false);
            this.plugin.stopWatchingMap(map);
            this.plugin.getRenderManager().removeRenderTasksIf(task -> {
                if (task instanceof MapUpdateTask) {
                    return ((MapUpdateTask)task).getMap().equals(map);
                }
                if (task instanceof WorldRegionRenderTask) {
                    return ((WorldRegionRenderTask)task).getMap().equals(map);
                }
                return false;
            });
            source.sendMessage(Text.of(new Object[]{TextColor.GREEN, "Map ", TextColor.WHITE, mapString, TextColor.GREEN, " is now frozen and will no longer be automatically updated!"}));
            source.sendMessage(Text.of(TextColor.GRAY, "Any currently scheduled updates for this map have been cancelled."));
            this.plugin.save();
        }).start();
        return 1;
    }

    public int unfreezeCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        String mapString = (String)context.getArgument("map", String.class);
        BmMap map = this.parseMap(mapString).orElse(null);
        if (map == null) {
            source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no ", this.helper.mapHelperHover(), " with this name: ", TextColor.WHITE, mapString}));
            return 0;
        }
        PluginState.MapState mapState = this.plugin.getPluginState().getMapState(map);
        if (mapState.isUpdateEnabled()) {
            source.sendMessage(Text.of(TextColor.RED, "This map is not frozen!"));
            return 0;
        }
        new Thread(() -> {
            mapState.setUpdateEnabled(true);
            this.plugin.startWatchingMap(map);
            this.plugin.getRenderManager().scheduleRenderTask(new MapUpdateTask(map));
            source.sendMessage(Text.of(new Object[]{TextColor.GREEN, "Map ", TextColor.WHITE, mapString, TextColor.GREEN, " is no longer frozen and will be automatically updated!"}));
            this.plugin.save();
        }).start();
        return 1;
    }

    public int forceUpdateCommand(CommandContext<S> context) {
        return this.updateCommand(context, true);
    }

    public int updateCommand(CommandContext<S> context) {
        return this.updateCommand(context, false);
    }

    public int updateCommand(CommandContext<S> context, boolean force) {
        Vector2i center;
        int radius;
        BmMap mapToRender;
        World worldToRender;
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        Optional<String> worldOrMap = this.getOptionalArgument(context, "world|map", String.class);
        if (worldOrMap.isPresent()) {
            worldToRender = this.parseWorld(worldOrMap.get()).orElse(null);
            if (worldToRender == null) {
                mapToRender = this.parseMap(worldOrMap.get()).orElse(null);
                if (mapToRender == null) {
                    source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no ", this.helper.worldHelperHover(), " or ", this.helper.mapHelperHover(), " with this name: ", TextColor.WHITE, worldOrMap.get()}));
                    return 0;
                }
            } else {
                mapToRender = null;
            }
        } else {
            worldToRender = source.getWorld().orElse(null);
            mapToRender = null;
            if (worldToRender == null) {
                source.sendMessage(Text.of(TextColor.RED, "Can't detect a world from this command-source, you'll have to define a world or a map to update!").setHoverText(Text.of(TextColor.GRAY, "/bluemap " + (force ? "force-update" : "update") + " <world|map>")));
                return 0;
            }
        }
        if ((radius = this.getOptionalArgument(context, "radius", Integer.class).orElse(-1).intValue()) >= 0) {
            Optional<Double> x = this.getOptionalArgument(context, "x", Double.class);
            Optional<Double> z = this.getOptionalArgument(context, "z", Double.class);
            if (x.isPresent() && z.isPresent()) {
                center = new Vector2i(x.get(), z.get());
            } else {
                Vector3d position = source.getPosition().orElse(null);
                if (position == null) {
                    source.sendMessage(Text.of(TextColor.RED, "Can't detect a position from this command-source, you'll have to define x,z coordinates to update with a radius!").setHoverText(Text.of(TextColor.GRAY, "/bluemap " + (force ? "force-update" : "update") + " <x> <z> " + radius)));
                    return 0;
                }
                center = position.toVector2(true).floor().toInt();
            }
        } else {
            center = null;
        }
        new Thread(() -> {
            try {
                ArrayList<BmMap> maps = new ArrayList<BmMap>();
                if (worldToRender != null) {
                    this.plugin.getServerInterface().persistWorldChanges(worldToRender.getUUID());
                    for (BmMap map : this.plugin.getMapTypes()) {
                        if (!map.getWorld().getUUID().equals(worldToRender.getUUID())) continue;
                        maps.add(map);
                    }
                } else {
                    this.plugin.getServerInterface().persistWorldChanges(mapToRender.getWorld().getUUID());
                    maps.add(mapToRender);
                }
                if (maps.isEmpty()) {
                    source.sendMessage(Text.of(TextColor.RED, "No map has been found for this world that could be updated!"));
                    return;
                }
                for (BmMap map : maps) {
                    MapUpdateTask updateTask = new MapUpdateTask(map, center, radius);
                    this.plugin.getRenderManager().scheduleRenderTask(updateTask);
                    if (force) {
                        MapRenderState state = map.getRenderState();
                        updateTask.getRegions().forEach(region -> state.setRenderTime((Vector2i)region, -1L));
                    }
                    source.sendMessage(Text.of(new Object[]{TextColor.GREEN, "Created new Update-Task for map '" + map.getId() + "' ", TextColor.GRAY, "(" + updateTask.getRegions().size() + " regions, ~" + (long)updateTask.getRegions().size() * 1024L + " chunks)"}));
                }
                source.sendMessage(Text.of(new Object[]{TextColor.GREEN, "Use ", TextColor.GRAY, "/bluemap", TextColor.GREEN, " to see the progress."}));
            }
            catch (IOException ex) {
                source.sendMessage(Text.of(TextColor.RED, "There was an unexpected exception trying to save the world. Please check the console for more details..."));
                Logger.global.logError("Unexpected exception trying to save the world!", ex);
            }
        }).start();
        return 1;
    }

    public int cancelCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        Optional<String> ref = this.getOptionalArgument(context, "task-ref", String.class);
        if (!ref.isPresent()) {
            this.plugin.getRenderManager().removeAllRenderTasks();
            source.sendMessage(Text.of(TextColor.GREEN, "All tasks cancelled!"));
            source.sendMessage(Text.of(TextColor.GRAY, "(Note, that an already started task might not be removed immediately. Some tasks needs to do some tidying-work first)"));
            return 1;
        }
        Optional<RenderTask> task = this.helper.getTaskForRef(ref.get());
        if (!task.isPresent()) {
            source.sendMessage(Text.of(TextColor.RED, "There is no task with this reference '" + ref.get() + "'!"));
            return 0;
        }
        if (this.plugin.getRenderManager().removeRenderTask(task.get())) {
            source.sendMessage(Text.of(TextColor.GREEN, "Task cancelled!"));
            source.sendMessage(Text.of(TextColor.GRAY, "(Note, that an already started task might not be removed immediately. Some tasks needs to do some tidying-work first)"));
            return 1;
        }
        source.sendMessage(Text.of(TextColor.RED, "This task is either completed or got cancelled already!"));
        return 0;
    }

    public int purgeCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        String mapId = (String)context.getArgument("map", String.class);
        new Thread(() -> {
            try {
                Path mapFolder = this.plugin.getRenderConfig().getWebRoot().toPath().resolve("data").resolve(mapId);
                if (!Files.isDirectory(mapFolder, new LinkOption[0])) {
                    source.sendMessage(Text.of(TextColor.RED, "There is no map-data to purge for the map-id '" + mapId + "'!"));
                    return;
                }
                Optional<BmMap> optMap = this.parseMap(mapId);
                MapPurgeTask purgeTask = optMap.isPresent() ? new MapPurgeTask(optMap.get()) : new MapPurgeTask(mapFolder);
                this.plugin.getRenderManager().scheduleRenderTaskNext(purgeTask);
                source.sendMessage(Text.of(TextColor.GREEN, "Created new Task to purge map '" + mapId + "'"));
                if (optMap.isPresent()) {
                    MapUpdateTask updateTask = new MapUpdateTask(optMap.get());
                    this.plugin.getRenderManager().scheduleRenderTask(updateTask);
                    source.sendMessage(Text.of(TextColor.GREEN, "Created new Update-Task for map '" + mapId + "'"));
                    source.sendMessage(Text.of(TextColor.GRAY, "If you don't want to render this map again, you need to remove it from your configuration first!"));
                }
                source.sendMessage(Text.of(new Object[]{TextColor.GREEN, "Use ", TextColor.GRAY, "/bluemap", TextColor.GREEN, " to see the progress."}));
            }
            catch (IOException | IllegalArgumentException e) {
                source.sendMessage(Text.of(TextColor.RED, "There was an error trying to purge '" + mapId + "', see console for details."));
                Logger.global.logError("Failed to purge map '" + mapId + "'!", e);
            }
        }).start();
        return 1;
    }

    public int worldsCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        source.sendMessage(Text.of(TextColor.BLUE, "Worlds loaded by BlueMap:"));
        for (World world : this.plugin.getWorlds()) {
            source.sendMessage(Text.of(new Object[]{TextColor.GRAY, " - ", TextColor.WHITE, world.getName()}).setHoverText(Text.of(new Object[]{world.getSaveFolder(), TextColor.GRAY, " (" + world.getUUID() + ")"})));
        }
        return 1;
    }

    public int mapsCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        source.sendMessage(Text.of(TextColor.BLUE, "Maps loaded by BlueMap:"));
        for (BmMap map : this.plugin.getMapTypes()) {
            boolean unfrozen = this.plugin.getPluginState().getMapState(map).isUpdateEnabled();
            if (unfrozen) {
                source.sendMessage(Text.of(new Object[]{TextColor.GRAY, " - ", TextColor.WHITE, map.getId(), TextColor.GRAY, " (" + map.getName() + ")"}).setHoverText(Text.of(new Object[]{TextColor.WHITE, "World: ", TextColor.GRAY, map.getWorld().getName()})));
                continue;
            }
            source.sendMessage(Text.of(new Object[]{TextColor.GRAY, " - ", TextColor.WHITE, map.getId(), TextColor.GRAY, " (" + map.getName() + ") - ", TextColor.AQUA, TextFormat.ITALIC, "frozen!"}).setHoverText(Text.of(new Object[]{TextColor.WHITE, "World: ", TextColor.GRAY, map.getWorld().getName()})));
        }
        return 1;
    }

    public int createMarkerCommand(CommandContext<S> context) {
        Vector3d position;
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        String markerId = (String)context.getArgument("id", String.class);
        String markerLabel = ((String)context.getArgument("label", String.class)).replace("<", "&lt;").replace(">", "&gt;");
        String mapString = (String)context.getArgument("map", String.class);
        BmMap map = this.parseMap(mapString).orElse(null);
        if (map == null) {
            source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no ", this.helper.mapHelperHover(), " with this name: ", TextColor.WHITE, mapString}));
            return 0;
        }
        Optional<Double> x = this.getOptionalArgument(context, "x", Double.class);
        Optional<Double> y = this.getOptionalArgument(context, "y", Double.class);
        Optional<Double> z = this.getOptionalArgument(context, "z", Double.class);
        if (x.isPresent() && y.isPresent() && z.isPresent()) {
            position = new Vector3d(x.get(), y.get(), z.get());
        } else {
            position = source.getPosition().orElse(null);
            if (position == null) {
                source.sendMessage(Text.of(TextColor.RED, "Can't detect a position from this command-source, you'll have to define the x,y,z coordinates for the marker!").setHoverText(Text.of(TextColor.GRAY, "/bluemap marker create " + markerId + " [world|map] <x> <y> <z> <label>")));
                return 0;
            }
        }
        BlueMapAPI api = BlueMapAPI.getInstance().orElse(null);
        if (api == null) {
            source.sendMessage(Text.of(new Object[]{TextColor.RED, "MarkerAPI is not available, try ", TextColor.GRAY, "/bluemap reload"}));
            return 0;
        }
        Optional<BlueMapMap> apiMap = api.getMap(map.getId());
        if (!apiMap.isPresent()) {
            source.sendMessage(Text.of(new Object[]{TextColor.RED, "Failed to get map from API, try ", TextColor.GRAY, "/bluemap reload"}));
            return 0;
        }
        try {
            MarkerAPI markerApi = api.getMarkerAPI();
            MarkerSet set = markerApi.getMarkerSet(DEFAULT_MARKER_SET_ID).orElse(null);
            if (set == null) {
                set = markerApi.createMarkerSet(DEFAULT_MARKER_SET_ID);
                set.setLabel("Markers");
            }
            if (set.getMarker(markerId).isPresent()) {
                source.sendMessage(Text.of(new Object[]{TextColor.RED, "There already is a marker with this id: ", TextColor.WHITE, markerId}));
                return 0;
            }
            POIMarker marker = set.createPOIMarker(markerId, apiMap.get(), position);
            marker.setLabel(markerLabel);
            markerApi.save();
            MarkerIdSuggestionProvider.getInstance().forceUpdate();
        }
        catch (IOException e) {
            source.sendMessage(Text.of(TextColor.RED, "There was an error trying to add the marker, please check the console for details!"));
            Logger.global.logError("Exception trying to add a marker!", e);
        }
        source.sendMessage(Text.of(TextColor.GREEN, "Marker added!"));
        return 1;
    }

    public int removeMarkerCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        String markerId = (String)context.getArgument("id", String.class);
        BlueMapAPI api = BlueMapAPI.getInstance().orElse(null);
        if (api == null) {
            source.sendMessage(Text.of(new Object[]{TextColor.RED, "MarkerAPI is not available, try ", TextColor.GRAY, "/bluemap reload"}));
            return 0;
        }
        try {
            MarkerAPI markerApi = api.getMarkerAPI();
            MarkerSet set = markerApi.createMarkerSet(DEFAULT_MARKER_SET_ID);
            if (!set.removeMarker(markerId)) {
                source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no marker with this id: ", TextColor.WHITE, markerId}));
            }
            markerApi.save();
            MarkerIdSuggestionProvider.getInstance().forceUpdate();
        }
        catch (IOException e) {
            source.sendMessage(Text.of(TextColor.RED, "There was an error trying to remove the marker, please check the console for details!"));
            Logger.global.logError("Exception trying to remove a marker!", e);
        }
        source.sendMessage(Text.of(TextColor.GREEN, "Marker removed!"));
        return 1;
    }

    public int listMarkersCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        BlueMapAPI api = BlueMapAPI.getInstance().orElse(null);
        if (api == null) {
            source.sendMessage(Text.of(new Object[]{TextColor.RED, "MarkerAPI is not available, try ", TextColor.GRAY, "/bluemap reload"}));
            return 0;
        }
        source.sendMessage(Text.of(TextColor.BLUE, "All Markers:"));
        int i = 0;
        Collection<String> markerIds = MarkerIdSuggestionProvider.getInstance().getPossibleValues();
        for (String markerId : markerIds) {
            if (i++ >= 40) {
                source.sendMessage(Text.of(TextColor.GRAY, "[" + (markerIds.size() - 40) + " more ...]"));
                break;
            }
            source.sendMessage(Text.of(new Object[]{TextColor.GRAY, " - ", TextColor.WHITE, markerId}));
        }
        return 1;
    }
}

