/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin;

import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

@DebugDump
public class PluginConfig {
    private boolean liveUpdatesEnabled;
    private boolean skinDownloadEnabled;
    private Collection<String> hiddenGameModes;
    private boolean hideInvisible;
    private boolean hideSneaking;
    private int playerRenderLimit;
    private long fullUpdateIntervalMinutes;

    public PluginConfig(ConfigurationNode node) {
        this.liveUpdatesEnabled = node.node("liveUpdates").getBoolean(true);
        this.skinDownloadEnabled = node.node("skinDownload").getBoolean(true);
        this.hiddenGameModes = new ArrayList<String>();
        for (ConfigurationNode configurationNode : node.node("hiddenGameModes").childrenList()) {
            this.hiddenGameModes.add(configurationNode.getString());
        }
        this.hiddenGameModes = Collections.unmodifiableCollection(this.hiddenGameModes);
        this.hideInvisible = node.node("hideInvisible").getBoolean(true);
        this.hideSneaking = node.node("hideSneaking").getBoolean(false);
        this.playerRenderLimit = node.node("playerRenderLimit").getInt(-1);
        this.fullUpdateIntervalMinutes = node.node("fullUpdateInterval").getLong(TimeUnit.HOURS.toMinutes(24L));
    }

    public boolean isLiveUpdatesEnabled() {
        return this.liveUpdatesEnabled;
    }

    public boolean isSkinDownloadEnabled() {
        return this.skinDownloadEnabled;
    }

    public Collection<String> getHiddenGameModes() {
        return this.hiddenGameModes;
    }

    public boolean isHideInvisible() {
        return this.hideInvisible;
    }

    public boolean isHideSneaking() {
        return this.hideSneaking;
    }

    public int getPlayerRenderLimit() {
        return this.playerRenderLimit;
    }

    public long getFullUpdateIntervalMinutes() {
        return this.fullUpdateIntervalMinutes;
    }
}

