/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin;

import de.bluecolored.bluemap.common.BlueMapService;
import de.bluecolored.bluemap.common.InterruptableReentrantLock;
import de.bluecolored.bluemap.common.api.BlueMapAPIImpl;
import de.bluecolored.bluemap.common.plugin.PluginConfig;
import de.bluecolored.bluemap.common.plugin.PluginState;
import de.bluecolored.bluemap.common.plugin.RegionFileWatchService;
import de.bluecolored.bluemap.common.plugin.serverinterface.ServerEventListener;
import de.bluecolored.bluemap.common.plugin.serverinterface.ServerInterface;
import de.bluecolored.bluemap.common.plugin.skins.PlayerSkinUpdater;
import de.bluecolored.bluemap.common.rendermanager.RenderManager;
import de.bluecolored.bluemap.core.MinecraftVersion;
import de.bluecolored.bluemap.core.config.CoreConfig;
import de.bluecolored.bluemap.core.config.RenderConfig;
import de.bluecolored.bluemap.core.config.WebServerConfig;
import de.bluecolored.bluemap.core.debug.DebugDump;
import de.bluecolored.bluemap.core.debug.StateDumper;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.resourcepack.ParseResourceException;
import de.bluecolored.bluemap.core.webserver.WebServer;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.shadow.configurate.BasicConfigurationNode;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Timer;
import java.util.UUID;

@DebugDump
public class Plugin
implements ServerEventListener {
    public static final String PLUGIN_ID = "bluemap";
    public static final String PLUGIN_NAME = "BlueMap";
    private final InterruptableReentrantLock loadingLock = new InterruptableReentrantLock();
    private final MinecraftVersion minecraftVersion;
    private final String implementationType;
    private final ServerInterface serverInterface;
    private BlueMapService blueMap;
    private BlueMapAPIImpl api;
    private CoreConfig coreConfig;
    private RenderConfig renderConfig;
    private WebServerConfig webServerConfig;
    private PluginConfig pluginConfig;
    private PluginState pluginState;
    private Map<UUID, World> worlds;
    private Map<String, BmMap> maps;
    private RenderManager renderManager;
    private WebServer webServer;
    private Timer daemonTimer;
    private Map<String, RegionFileWatchService> regionFileWatchServices;
    private PlayerSkinUpdater skinUpdater;
    private boolean loaded = false;

    public Plugin(MinecraftVersion minecraftVersion, String implementationType, ServerInterface serverInterface) {
        this.minecraftVersion = minecraftVersion;
        this.implementationType = implementationType.toLowerCase();
        this.serverInterface = serverInterface;
        StateDumper.global().register(this);
    }

    /*
     * Exception decompiling
     */
    public void load() throws IOException, ParseResourceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        try {
            this.loadingLock.interruptAndLock();
            Plugin plugin = this;
            synchronized (plugin) {
                this.save();
                if (this.api != null) {
                    this.api.unregister();
                }
                this.api = null;
                this.serverInterface.unregisterAllListeners();
                this.skinUpdater = null;
                if (this.daemonTimer != null) {
                    this.daemonTimer.cancel();
                }
                this.daemonTimer = null;
                if (this.regionFileWatchServices != null) {
                    this.regionFileWatchServices.values().forEach(RegionFileWatchService::close);
                    this.regionFileWatchServices.clear();
                }
                this.regionFileWatchServices = null;
                if (this.renderManager != null) {
                    this.renderManager.stop();
                }
                this.renderManager = null;
                if (this.webServer != null) {
                    this.webServer.close();
                }
                this.webServer = null;
                this.blueMap = null;
                this.worlds = null;
                this.maps = null;
                this.coreConfig = null;
                this.renderConfig = null;
                this.webServerConfig = null;
                this.pluginConfig = null;
                this.pluginState = null;
                this.loaded = false;
            }
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    public void reload() throws IOException, ParseResourceException {
        this.unload();
        this.load();
    }

    public synchronized void save() {
        if (this.pluginState != null) {
            try {
                GsonConfigurationLoader loader = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().file(new File(this.getCoreConfig().getDataFolder(), "pluginState.json"))).build();
                loader.save(((BasicConfigurationNode)loader.createNode()).set(PluginState.class, (Object)this.pluginState));
            }
            catch (IOException ex) {
                Logger.global.logError("Failed to save pluginState.json!", ex);
            }
        }
        if (this.maps != null) {
            for (BmMap map : this.maps.values()) {
                map.save();
            }
        }
    }

    public synchronized void startWatchingMap(BmMap map) {
        this.stopWatchingMap(map);
        try {
            RegionFileWatchService watcher = new RegionFileWatchService(this.renderManager, map, false);
            watcher.start();
            this.regionFileWatchServices.put(map.getId(), watcher);
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to create file-watcher for map: " + map.getId() + " (This means the map might not automatically update)", ex);
        }
    }

    public synchronized void stopWatchingMap(BmMap map) {
        RegionFileWatchService watcher = this.regionFileWatchServices.remove(map.getId());
        if (watcher != null) {
            watcher.close();
        }
    }

    public boolean flushWorldUpdates(UUID worldUUID) throws IOException {
        return this.serverInterface.persistWorldChanges(worldUUID);
    }

    @Override
    public void onPlayerJoin(UUID playerUuid) {
        this.checkPausedByPlayerCount();
    }

    @Override
    public void onPlayerLeave(UUID playerUuid) {
        this.checkPausedByPlayerCount();
    }

    public boolean checkPausedByPlayerCount() {
        if (this.getPluginConfig().getPlayerRenderLimit() > 0 && this.getServerInterface().getOnlinePlayers().size() >= this.getPluginConfig().getPlayerRenderLimit()) {
            if (this.renderManager.isRunning()) {
                this.renderManager.stop();
            }
            return true;
        }
        if (!this.renderManager.isRunning() && this.getPluginState().isRenderThreadsEnabled()) {
            this.renderManager.start(this.getCoreConfig().getRenderThreadCount());
        }
        return false;
    }

    public ServerInterface getServerInterface() {
        return this.serverInterface;
    }

    public CoreConfig getCoreConfig() {
        return this.coreConfig;
    }

    public RenderConfig getRenderConfig() {
        return this.renderConfig;
    }

    public WebServerConfig getWebServerConfig() {
        return this.webServerConfig;
    }

    public PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    public PluginState getPluginState() {
        return this.pluginState;
    }

    public World getWorld(UUID uuid) {
        return this.worlds.get(uuid);
    }

    public Collection<World> getWorlds() {
        return this.worlds.values();
    }

    public Collection<BmMap> getMapTypes() {
        return this.maps.values();
    }

    public RenderManager getRenderManager() {
        return this.renderManager;
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String getImplementationType() {
        return this.implementationType;
    }

    public MinecraftVersion getMinecraftVersion() {
        return this.minecraftVersion;
    }

    private void initFileWatcherTasks() {
        for (BmMap map : this.maps.values()) {
            if (!this.pluginState.getMapState(map).isUpdateEnabled()) continue;
            this.startWatchingMap(map);
        }
    }
}

