/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.live;

import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.common.plugin.PluginConfig;
import de.bluecolored.bluemap.common.plugin.serverinterface.Player;
import de.bluecolored.bluemap.common.plugin.serverinterface.ServerInterface;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.webserver.HttpRequest;
import de.bluecolored.bluemap.core.webserver.HttpRequestHandler;
import de.bluecolored.bluemap.core.webserver.HttpResponse;
import de.bluecolored.bluemap.core.webserver.HttpStatusCode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class LiveAPIRequestHandler
implements HttpRequestHandler {
    private HttpRequestHandler notFoundHandler;
    private Map<String, HttpRequestHandler> liveAPIRequests;
    private ServerInterface server;
    private PluginConfig config;

    public LiveAPIRequestHandler(ServerInterface server, PluginConfig config, HttpRequestHandler notFoundHandler) {
        this.server = server;
        this.notFoundHandler = notFoundHandler;
        this.liveAPIRequests = new HashMap<String, HttpRequestHandler>();
        this.liveAPIRequests.put("live", this::handleLivePingRequest);
        this.liveAPIRequests.put("live/players", this::handlePlayersRequest);
        this.config = config;
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        HttpRequestHandler handler;
        if (!this.config.isLiveUpdatesEnabled()) {
            return this.notFoundHandler.handle(request);
        }
        String path = request.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((handler = this.liveAPIRequests.get(path)) != null) {
            HttpResponse response = handler.handle(request);
            response.addHeader("Server", "BlueMap v" + BlueMap.VERSION);
            response.addHeader("Cache-Control", "no-cache");
            response.addHeader("Content-Type", "application/json");
            return response;
        }
        return this.notFoundHandler.handle(request);
    }

    public HttpResponse handleLivePingRequest(HttpRequest request) {
        HttpResponse response = new HttpResponse(HttpStatusCode.OK);
        response.setData("{\"status\":\"OK\"}");
        return response;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public HttpResponse handlePlayersRequest(HttpRequest request) {
        if (!request.getMethod().equalsIgnoreCase("GET")) {
            return new HttpResponse(HttpStatusCode.BAD_REQUEST);
        }
        try (StringWriter data = new StringWriter();){
            HttpResponse httpResponse;
            try (JsonWriter json = new JsonWriter((Writer)data);){
                json.beginObject();
                json.name("players").beginArray();
                for (Player player : this.server.getOnlinePlayers()) {
                    if (!player.isOnline() || this.config.isHideInvisible() && player.isInvisible() || this.config.isHideSneaking() && player.isSneaking() || this.config.getHiddenGameModes().contains(player.getGamemode().getId())) continue;
                    json.beginObject();
                    json.name("uuid").value(player.getUuid().toString());
                    json.name("name").value(player.getName().toPlainString());
                    json.name("world").value(player.getWorld().toString());
                    json.name("position").beginObject();
                    json.name("x").value(player.getPosition().getX());
                    json.name("y").value(player.getPosition().getY());
                    json.name("z").value(player.getPosition().getZ());
                    json.endObject();
                    json.endObject();
                }
                json.endArray();
                json.endObject();
                HttpResponse response = new HttpResponse(HttpStatusCode.OK);
                response.setData(data.toString());
                httpResponse = response;
            }
            return httpResponse;
        }
        catch (IOException ex) {
            return new HttpResponse(HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }
}

