/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api.render;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.renderer.RenderAPI;
import de.bluecolored.bluemap.common.api.BlueMapAPIImpl;
import de.bluecolored.bluemap.common.api.BlueMapMapImpl;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.MapPurgeTask;
import de.bluecolored.bluemap.common.rendermanager.MapUpdateTask;
import de.bluecolored.bluemap.common.rendermanager.RenderManager;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.core.world.Grid;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;

public class RenderAPIImpl
implements RenderAPI {
    private final BlueMapAPIImpl api;
    private final Plugin plugin;
    private final RenderManager renderManager;

    public RenderAPIImpl(BlueMapAPIImpl api, Plugin plugin) {
        this.api = api;
        this.plugin = plugin;
        this.renderManager = plugin.getRenderManager();
    }

    @Override
    public void render(UUID world, Vector3i blockPosition) {
        this.render(this.api.getWorldForUuid(world), blockPosition);
    }

    @Override
    public void render(String mapId, Vector3i blockPosition) {
        this.render((BlueMapMap)this.api.getMapForId(mapId), blockPosition);
    }

    @Override
    public void render(String mapId, Vector2i tile) {
        this.render((BlueMapMap)this.api.getMapForId(mapId), tile);
    }

    @Override
    public void render(BlueMapMap map, Vector2i tile) {
        BlueMapMapImpl cmap = this.castMap(map);
        Grid regionGrid = cmap.getWorld().getWorld().getRegionGrid();
        Grid tileGrid = cmap.getMapType().getHiresModelManager().getTileGrid();
        for (Vector2i region : tileGrid.getIntersecting(tile, regionGrid)) {
            this.renderManager.scheduleRenderTask(new WorldRegionRenderTask(cmap.getMapType(), region));
        }
    }

    @Override
    public boolean scheduleMapUpdateTask(BlueMapMap map, boolean force) {
        BlueMapMapImpl cmap = this.castMap(map);
        return this.renderManager.scheduleRenderTask(new MapUpdateTask(cmap.getMapType(), force));
    }

    @Override
    public boolean scheduleMapUpdateTask(BlueMapMap map, Collection<Vector2i> regions, boolean force) {
        BlueMapMapImpl cmap = this.castMap(map);
        return this.renderManager.scheduleRenderTask(new MapUpdateTask(cmap.getMapType(), regions, force));
    }

    @Override
    public boolean scheduleMapPurgeTask(BlueMapMap map) throws IOException {
        BlueMapMapImpl cmap = this.castMap(map);
        return this.renderManager.scheduleRenderTask(new MapPurgeTask(cmap.getMapType()));
    }

    @Override
    public int renderQueueSize() {
        return this.renderManager.getScheduledRenderTasks().size();
    }

    @Override
    public int renderThreadCount() {
        return this.renderManager.getWorkerThreadCount();
    }

    @Override
    public boolean isRunning() {
        return this.renderManager.isRunning();
    }

    @Override
    public void start() {
        if (!this.isRunning()) {
            this.renderManager.start(this.api.plugin.getCoreConfig().getRenderThreadCount());
        }
        this.plugin.getPluginState().setRenderThreadsEnabled(true);
    }

    @Override
    public void pause() {
        this.renderManager.stop();
        this.plugin.getPluginState().setRenderThreadsEnabled(false);
    }

    private BlueMapMapImpl castMap(BlueMapMap map) {
        BlueMapMapImpl cmap = map instanceof BlueMapMapImpl ? (BlueMapMapImpl)map : this.api.getMapForId(map.getId());
        return cmap;
    }
}

