/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api.marker;

import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.marker.Shape;
import de.bluecolored.bluemap.api.marker.ShapeMarker;
import de.bluecolored.bluemap.common.api.marker.MarkerFileFormatException;
import de.bluecolored.bluemap.common.api.marker.ObjectMarkerImpl;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.serialize.SerializationException;
import java.awt.Color;
import java.util.List;
import java.util.Objects;

public class ShapeMarkerImpl
extends ObjectMarkerImpl
implements ShapeMarker {
    public static final String MARKER_TYPE = "shape";
    private Shape shape;
    private float shapeY;
    private boolean depthTest;
    private int lineWidth;
    private Color lineColor;
    private Color fillColor;
    private boolean hasUnsavedChanges;

    public ShapeMarkerImpl(String id, BlueMapMap map, Vector3d position, Shape shape, float shapeY) {
        super(id, map, position);
        Objects.requireNonNull(shape);
        this.shape = shape;
        this.shapeY = shapeY;
        this.lineWidth = 2;
        this.lineColor = new Color(255, 0, 0, 200);
        this.fillColor = new Color(200, 0, 0, 100);
        this.hasUnsavedChanges = true;
    }

    @Override
    public String getType() {
        return MARKER_TYPE;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public float getShapeY() {
        return this.shapeY;
    }

    @Override
    public synchronized void setShape(Shape shape, float shapeY) {
        Objects.requireNonNull(shape);
        this.shape = shape;
        this.shapeY = shapeY;
        this.hasUnsavedChanges = true;
    }

    @Override
    public boolean isDepthTestEnabled() {
        return this.depthTest;
    }

    @Override
    public void setDepthTestEnabled(boolean enabled) {
        this.depthTest = enabled;
        this.hasUnsavedChanges = true;
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        this.hasUnsavedChanges = true;
    }

    @Override
    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public synchronized void setLineColor(Color color) {
        Objects.requireNonNull(color);
        this.lineColor = color;
        this.hasUnsavedChanges = true;
    }

    @Override
    public Color getFillColor() {
        return this.fillColor;
    }

    @Override
    public synchronized void setFillColor(Color color) {
        Objects.requireNonNull(color);
        this.fillColor = color;
        this.hasUnsavedChanges = true;
    }

    @Override
    public void load(BlueMapAPI api, ConfigurationNode markerNode, boolean overwriteChanges) throws MarkerFileFormatException {
        super.load(api, markerNode, overwriteChanges);
        if (!overwriteChanges && this.hasUnsavedChanges) {
            return;
        }
        this.hasUnsavedChanges = false;
        this.shape = this.readShape(markerNode.node(MARKER_TYPE));
        this.shapeY = (float)markerNode.node("shapeY").getDouble(markerNode.node("height").getDouble(64.0));
        this.depthTest = markerNode.node("depthTest").getBoolean(true);
        this.lineWidth = markerNode.node("lineWidth").getInt(2);
        ConfigurationNode lineColorNode = markerNode.node("lineColor");
        if (lineColorNode.virtual()) {
            lineColorNode = markerNode.node("borderColor");
        }
        this.lineColor = ShapeMarkerImpl.readColor(lineColorNode);
        this.fillColor = ShapeMarkerImpl.readColor(markerNode.node("fillColor"));
    }

    @Override
    public void save(ConfigurationNode markerNode) throws SerializationException {
        super.save(markerNode);
        ShapeMarkerImpl.writeShape(markerNode.node(MARKER_TYPE), this.shape);
        markerNode.node("shapeY").set(Float.valueOf((float)Math.round(this.shapeY * 1000.0f) / 1000.0f));
        markerNode.node("depthTest").set(this.depthTest);
        markerNode.node("lineWidth").set(this.lineWidth);
        ShapeMarkerImpl.writeColor(markerNode.node("lineColor"), this.lineColor);
        ShapeMarkerImpl.writeColor(markerNode.node("fillColor"), this.fillColor);
        this.hasUnsavedChanges = false;
    }

    private Shape readShape(ConfigurationNode node) throws MarkerFileFormatException {
        List<? extends ConfigurationNode> posNodes = node.childrenList();
        if (posNodes.size() < 3) {
            throw new MarkerFileFormatException("Failed to read shape: point-list has fewer than 3 entries!");
        }
        Vector2d[] positions = new Vector2d[posNodes.size()];
        for (int i = 0; i < positions.length; ++i) {
            positions[i] = ShapeMarkerImpl.readShapePos(posNodes.get(i));
        }
        return new Shape(positions);
    }

    private static Vector2d readShapePos(ConfigurationNode node) throws MarkerFileFormatException {
        ConfigurationNode nx = node.node("x");
        ConfigurationNode nz = node.node("z");
        if (nx.virtual() || nz.virtual()) {
            throw new MarkerFileFormatException("Failed to read shape position: Node x or z is not set!");
        }
        return new Vector2d(nx.getDouble(), nz.getDouble());
    }

    private static Color readColor(ConfigurationNode node) throws MarkerFileFormatException {
        ConfigurationNode nr = node.node("r");
        ConfigurationNode ng = node.node("g");
        ConfigurationNode nb = node.node("b");
        ConfigurationNode na = node.node("a");
        if (nr.virtual() || ng.virtual() || nb.virtual()) {
            throw new MarkerFileFormatException("Failed to read color: Node r,g or b is not set!");
        }
        float alpha = (float)na.getDouble(1.0);
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new MarkerFileFormatException("Failed to read color: alpha value out of range (0-1)!");
        }
        try {
            return new Color(nr.getInt(), ng.getInt(), nb.getInt(), (int)(alpha * 255.0f));
        }
        catch (IllegalArgumentException ex) {
            throw new MarkerFileFormatException("Failed to read color: " + ex.getMessage(), ex);
        }
    }

    private static void writeShape(ConfigurationNode node, Shape shape) throws SerializationException {
        for (int i = 0; i < shape.getPointCount(); ++i) {
            ConfigurationNode pointNode = node.appendListNode();
            Vector2d point = shape.getPoint(i);
            pointNode.node("x").set((double)Math.round(point.getX() * 1000.0) / 1000.0);
            pointNode.node("z").set((double)Math.round(point.getY() * 1000.0) / 1000.0);
        }
    }

    private static void writeColor(ConfigurationNode node, Color color) throws SerializationException {
        int r = color.getRed();
        int g2 = color.getGreen();
        int b = color.getBlue();
        float a = (float)color.getAlpha() / 255.0f;
        node.node("r").set(r);
        node.node("g").set(g2);
        node.node("b").set(b);
        node.node("a").set(Float.valueOf(a));
    }
}

