/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api.marker;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.marker.POIMarker;
import de.bluecolored.bluemap.common.api.marker.MarkerFileFormatException;
import de.bluecolored.bluemap.common.api.marker.MarkerImpl;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.serialize.SerializationException;

public class POIMarkerImpl
extends MarkerImpl
implements POIMarker {
    public static final String MARKER_TYPE = "poi";
    private String iconAddress = "assets/poi.svg";
    private Vector2i anchor = new Vector2i(25, 45);
    private boolean hasUnsavedChanges = true;

    public POIMarkerImpl(String id, BlueMapMap map, Vector3d position) {
        super(id, map, position);
    }

    @Override
    public String getType() {
        return MARKER_TYPE;
    }

    @Override
    public String getIconAddress() {
        return this.iconAddress;
    }

    @Override
    public Vector2i getAnchor() {
        return this.anchor;
    }

    @Override
    public synchronized void setIcon(String iconAddress, Vector2i anchor) {
        this.iconAddress = iconAddress;
        this.anchor = anchor;
        this.hasUnsavedChanges = true;
    }

    @Override
    public synchronized void load(BlueMapAPI api, ConfigurationNode markerNode, boolean overwriteChanges) throws MarkerFileFormatException {
        super.load(api, markerNode, overwriteChanges);
        if (!overwriteChanges && this.hasUnsavedChanges) {
            return;
        }
        this.hasUnsavedChanges = false;
        this.iconAddress = markerNode.node("icon").getString("assets/poi.svg");
        ConfigurationNode anchorNode = markerNode.node("anchor");
        if (anchorNode.virtual()) {
            anchorNode = markerNode.node("iconAnchor");
        }
        this.anchor = POIMarkerImpl.readAnchor(anchorNode);
    }

    @Override
    public synchronized void save(ConfigurationNode markerNode) throws SerializationException {
        super.save(markerNode);
        markerNode.node("icon").set(this.iconAddress);
        POIMarkerImpl.writeAnchor(markerNode.node("anchor"), this.anchor);
        this.hasUnsavedChanges = false;
    }

    private static Vector2i readAnchor(ConfigurationNode node) {
        return new Vector2i(node.node("x").getInt(0), node.node("y").getInt(0));
    }

    private static void writeAnchor(ConfigurationNode node, Vector2i anchor) throws SerializationException {
        node.node("x").set(anchor.getX());
        node.node("y").set(anchor.getY());
    }
}

